// -*- c-basic-offset: 2 -*-

package javagroup.tools.processmanager;

import javagroup.process.ProcessCreationException;
import javagroup.process.ProcessManagerHolder;
import javagroup.swing.HistoryComboModel;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LaunchProcessPanel extends JPanel implements ActionListener {
    /**
     * History of commands that have been entered into the combo box *
     */
    protected HistoryComboModel _comboModel;
    protected JComboBox _classNameField;
    protected JButton _launchButton;

    public LaunchProcessPanel() {

        instantiateComponents();
        addAndLayoutComponents();
        registerListeners();

    }

    protected void instantiateComponents() {
        _comboModel = new HistoryComboModel();
        _classNameField = new JComboBox(_comboModel);

        _classNameField.setEditable(true);
        _launchButton = new JButton("Launch");
    }

    protected void addAndLayoutComponents() {

        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();

        this.setLayout(gridbag);

        constraints.anchor = GridBagConstraints.NORTH;
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        gridbag.setConstraints(_classNameField, constraints);
        add(_classNameField);

        constraints.fill = GridBagConstraints.NONE;
        constraints.gridheight = GridBagConstraints.REMAINDER;
        constraints.weightx = 0.0;

        gridbag.setConstraints(_launchButton, constraints);
        add(_launchButton);

    }

    protected void registerListeners() {
        _launchButton.addActionListener(this);
    }

    protected void showErrorDialog(Exception e) {
        System.out.println(e);
    }

    public void actionPerformed(ActionEvent event) {
        String class_info = (String) _classNameField.getSelectedItem();

        try {
            _comboModel.addToHistory(class_info);
            ProcessManagerHolder.getProcessManager()
                    .createProcessFromString(class_info).launch();
        } catch (ProcessCreationException e) {
            showErrorDialog(e);
        }
    }
}
