package javagroup.swing;

import javax.swing.*;

/**
 * A combo-box model that keeps a history of items that have been entered
 * into the box in the past.  Items are not duplicated, but are moved to
 * the top of the list as they are re-entered.
 * <p/>
 * <p>This class includes an ActionListener inner class that can be
 * attached to the combo box to automatically insert entries into the
 * history list as they are entered.
 *
 * @author Martin Pool
 * @version $Revision: 1.2 $, $Date: 1999/01/05 11:47:21 $
 */
public class HistoryComboModel
        extends DefaultListModel
        implements ComboBoxModel {
    /**
     * Current selection *
     */
    protected Object sel_;

    public void setSelectedItem(Object anItem) {
        sel_ = anItem;
        fireContentsChanged(this, -1, -1);
    }

    public Object getSelectedItem() {
        return sel_;
    }

    /**
     * Add an entry to the top of the history list.  This method should be
     * called whenever the application thinks the user has finished adding
     * something significant to the combo box: for example, when they press
     * the "Ok" button. *
     */
    public synchronized void addToHistory(String toAdd) {
        // If the string is already present in the history, remove it
        for (int i = 0; i < getSize();) {
            if (getElementAt(i).equals(toAdd))
                removeElementAt(i);
            else
                i++;
        }

        // Add to the start of the history
        insertElementAt(toAdd, 0);

        // In general, everything changed
        fireContentsChanged(this, -1, -1);
    }
}


