/*
 * Copyright (C) 1997 Luke Gorrie
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
 * MA 02139, USA.
 */

package javagroup.process;

import javagroup.util.WindowResource;

import java.awt.*;
import java.io.FileDescriptor;
import java.net.InetAddress;

/**
 * SecurityManager facilitating process identification.
 *
 * @author Luke Gorrie
 */
public class ProcessSecurityManager extends SecurityManager {

    protected ProcessManager _manager;

    public ProcessSecurityManager(ProcessManager manager) {
        _manager = manager;
    }

    ProcessSecurityManager() {
        super();
    }

    void setProcessManager(ProcessManager manager) {
        _manager = manager;
    }

    public JProcess getCurrentProcess() {
        ThreadGroup group = getThreadGroup();

        JProcess match = null;

        match = _manager.getProcessFor(group);

        if (match != null) {
            return match;
        }

        Class[] class_context = getClassContext();
        for (int i = 0; i < class_context.length; i++) {
            ClassLoader loader = class_context[i].getClassLoader();
            if (loader != null) {
                match = _manager.getProcessFor(loader);
                if (match != null)
                    return match;
            }
        }

        return null;

    }

    public void checkCreateClassLoader() {
    }

    public void checkAccess(Thread g) {
    }

    public void checkAccess(ThreadGroup g) {
    }

    public void checkExit(int status) {

        JProcess process = getCurrentProcess();
        if (process != null)
            _manager.kill(process.getPid());

        throw new SecurityException();
    }

    public void checkExec(String cmd) { /* DEBUG throw new SecurityException(); */
    }

    public void checkLink(String lib) {
    }

    public void checkRead(FileDescriptor fd) {
    }

    public void checkRead(String file) {
    }

    public void checkRead(String file, Object context) {
    }

    public void checkWrite(FileDescriptor fd) {
    }

    public void checkWrite(String file) {
    }

    public void checkDelete(String file) {
    }

    public void checkConnect(String host, int port) {
    }

    public void checkConnect(String host, int port, Object context) {
    }

    public void checkListen(int port) {
    }

    public void checkAccept(String host, int port) {
    }

    public void checkMulticast(InetAddress maddr) {
    }

    
    public void checkPropertiesAccess() {
    }

    public void checkPropertyAccess(String key) {
    }

    public void checkPropertyAccess(String key, String def) {
    }

    public boolean checkTopLevelWindow(Object obj) {

        Window window = null;
        if (obj instanceof Window)
            window = (Window) obj;
        JProcess process = _manager.getCurrentProcess();
        if ((process != null) && (window != null)) {
            process.registerAndBindToResource(new WindowResource(window));
        }

        return true;

    }

    public void checkPrintJobAccess() {
    }

    public void checkSystemClipboardAccess() {
    }

    public void checkAwtEventQueueAccess() {
    }

    public void checkPackageAccess(String pkg) {
    }

    public void checkPackageDefinition(String pkg) {
    }

    public void checkSetFactory() {
    }

    public void checkMemberAccess(Class clazz, int which) {
    }

    public void checkSecurityAccess(String provider) {
    }
}
