/*
 * Copyright (C) 1997 Luke Gorrie
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
 * MA 02139, USA.
 */

package javagroup.process;

/**
 * Garbage collector class.  A simple thread that calls doGarbageCollect()
 * on the ProcessManager every so often (every 5 secs by default).
 * <p/>
 * TODO: fine-tune timings
 *
 * @author Luke Gorrie
 */
public class ProcessGarbageCollector implements Runnable {

    // default time between collections
    public static final long DEFAULT_INTERVAL = 5000;

    /**
     * ProcessManager to call garbage collection on. *
     */
    protected ProcessManager _manager;
    /**
     * time between calls. *
     */
    protected long _waitTime;

    public ProcessGarbageCollector(ProcessManager manager) {
        this(manager, DEFAULT_INTERVAL);
    }

    public ProcessGarbageCollector(ProcessManager manager,
                                   long interval) {

        _manager = manager;
        _waitTime = interval;

        Thread main_thread = new Thread(this,
                "Process garbage collector");
        main_thread.setPriority(Thread.NORM_PRIORITY + 1);
        main_thread.setDaemon(true);
        main_thread.start();

    }

    public synchronized void wakeUp() {
        notifyAll();
    }

    public void run() {

        while (true) {
            try {
                synchronized (this) {
                    wait(_waitTime);
                }
            } catch (InterruptedException e) {
            }
            _manager.doGarbageCollect();
        }

    }

}

