/*
 * Copyright (C) 1997, 1988 Luke Gorrie
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
 * MA 02139, USA.
 */

package javagroup.misc;

import javagroup.process.JProcess;
import javagroup.process.ProcessCreationException;
import javagroup.process.ProcessManager;
import javagroup.process.ProcessManagerHolder;

/**
 * Simple class defining a "main" method for starting processes.
 *
 * @author Luke Gorrie
 * @version $Revision: 1.1 $, $Date: 1999/01/05 11:43:11 $
 */
public class LaunchProcess {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(
                    "Usage: LaunchProcess [-eclasspath url[,url]*] classname arg*");
            System.exit(1);
        }
        StringBuffer spec_buffer = new StringBuffer();
        for (int i = 0; i < args.length; i++) {
            spec_buffer.append(args[i]);
            spec_buffer.append(" ");
        }
        String spec = spec_buffer.toString();
        ProcessManager pm = ProcessManagerHolder.getProcessManager();
        try {
            JProcess process = pm.createProcessFromString(spec);
            process.launch();
            process.waitFor();
            System.err.println(
                    "Process \"" + process.toString() + "\" finished.");
        } catch (ProcessCreationException e) {
            System.err.println("Unable to create process: " + e);
            System.exit(1);
        }
    }
}

