package j3d.viewer;

/*
 *
 * (c) September 1998 by Mauro Marinilli
 *
 */


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import j3d.Utils;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.VirtualUniverse;
import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;


public class Viewer extends JFrame {
    JToolBar jToolBar1 = new JToolBar();
    JButton jButton1 = new JButton("open");
    JButton saveB = new JButton("save");
    JButton jButton3 = new JButton("new");
    JButton jButton4 = new JButton("help");
    JSplitPane viewPanel;
    VirtualUniverse vUniverse = new VirtualUniverse();
    SceneTreeModel model;
    SceneTreePanel panel;
    JPanel panelView = new JPanel();
    VU applet = new Simple3D();


    SimpleUniverse u;

    public Viewer() {
        try {
            draw();
        } catch (Exception e) {
            e.printStackTrace();
        }

//
        getContentPane().setLayout(new BorderLayout());

        Canvas3D c = Utils.getCanvas3D(getContentPane());
        getContentPane().add("Center", c);
        BranchGroup objRoot = new BranchGroup();
        u = new SimpleUniverse(c);
        objRoot.addChild(new ColorCube(0.1));
        objRoot.compile();
        u.addBranchGraph(objRoot);
//
    }

    private void draw() throws Exception {
        this.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                this_windowClosing(e);
            }
        });
        jButton1.setToolTipText("load a VirtualUniverse object from file");
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                jButton1_mouseClicked(e);
            }
        });
        saveB.setToolTipText("save this VirtualUniverse object to a file");
        saveB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                saveB_mouseClicked(e);
            }
        });
        jButton3.setToolTipText("create a blank VirtualObject");
        jButton4.setToolTipText("about Scene Viewer");
        jButton4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                jButton4_mouseClicked(e);
            }
        });
        this.getContentPane().add(jToolBar1, BorderLayout.NORTH);
        jToolBar1.add(jButton1, null);
        jToolBar1.add(saveB, null);
        jToolBar1.add(jButton3, null);
        jToolBar1.add(jButton4, null);


        VirtualUniverse vu = applet.getVU();

        model = new j3d.viewer.SceneTreeModel(vu);
        panel = new SceneTreePanel(model);



        JPanel panelStatus = new JPanel();
                Canvas3D c = Utils.getCanvas3D(panelStatus);

        panel.getTree().addTreeSelectionListener(new TreeListener(model));

        JScrollPane viewPanel2 = new JScrollPane(panelStatus);

        JScrollPane treeScroller = new JScrollPane(panel);
        viewPanel = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, treeScroller, viewPanel2);


        this.getContentPane().add(viewPanel);

        viewPanel.setContinuousLayout(true);
        setTitle("Scene Graph Viewer");
        setResizable(false);
        setSize(500, 300);
        show();
        System.out.println(vu.numLocales());


        MainFrame m = new MainFrame(applet, 256, 256);

    }

    void this_windowClosing(WindowEvent e) {
        System.exit(0);
    }

    void jButton1_mouseClicked(MouseEvent e) {
        FileDialog fd = new FileDialog(this);
        fd.setFile("*.obj");
        fd.show();
        if (fd.getFile() == null) return;
        if (!fd.getFile().endsWith(".obj")) return;
//    if (!fd.getFile().endsWith(".class")) return;

        File f = new File(fd.getDirectory(), fd.getFile());


    }

    void jButton4_mouseClicked(MouseEvent e) {
        InfoDialog info = new InfoDialog(this);
    }


    void saveB_mouseClicked(MouseEvent e) {
        FileDialog fd = new FileDialog(this, "Save .obj file", FileDialog.SAVE);
        fd.setFile("*.obj");
        fd.show();
        if (fd.getFile() == null) return;
        SerializeVU v = new SerializeVU(applet.getVU(), fd.getFile());

    }


    VirtualUniverse loadVU(String fileName) {

        Object ob = new Object();
        try {
            FileInputStream ostream = new FileInputStream(fileName);
            ObjectInputStream in = new ObjectInputStream(ostream);
            ob = in.readObject();
            in.close();

        } catch (Exception ie) {
            System.out.println("deserializing:" + fileName + ie.toString());
        }
        return null;
    }

    public static void main(String[] args) {
        new Viewer();
    }


    protected static class TreeListener implements TreeSelectionListener {
        SceneTreeModel model;

        public TreeListener(SceneTreeModel mdl) {
            model = mdl;
        }

        public void valueChanged(TreeSelectionEvent e) {
        }
    }


}

