package j3d.viewer;

/*
 *
 * (c) September 1998 by Mauro Marinilli
 *
 */


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import j3d.Utils;

import javax.media.j3d.*;
import javax.swing.*;
import java.awt.*;


public final class Simple3D extends VU {
    private final SimpleUniverse su;

    private static BranchGroup createSceneGraph() {
        final BranchGroup objRoot = new BranchGroup();

        final Transform3D spin = new Transform3D();
        final Transform3D tempspin = new Transform3D();

        spin.rotX(Math.PI / 4.0d);
        tempspin.rotY(Math.PI / 5.0d);
        spin.mul(tempspin);

        final TransformGroup objTrans = new TransformGroup(spin);
        objRoot.addChild(objTrans);

        objTrans.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
        objTrans.addChild(new ColorCube(0.4));


////

        objTrans.addChild(new ColorCube(0.3));
        objTrans.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
        objTrans.addChild(new ColorCube(0.1));
        objTrans.setCapability(BranchGroup.ALLOW_CHILDREN_READ);




////


        objRoot.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
        objRoot.compile();

        return objRoot;
    }


    public Simple3D() {
        setLayout(new BorderLayout());
        final Canvas3D c = Utils.getCanvas3D(new JPanel());
        add("Center", c);

        final BranchGroup scene = createSceneGraph();

        // SimpleUniverse is a Convenience Utility class
        final SimpleUniverse u = new SimpleUniverse(c);
        su = u;

        u.getViewingPlatform().setNominalViewingTransform();

        u.addBranchGraph(scene);
    }


    public VirtualUniverse getVU() {
        return su;
    }


    public static void main(final String[] args) {

        final Simple3D he = new Simple3D();
        new MainFrame(he, 256, 256);
    }
}
