package j3d.viewer;

/*
 *
 * (c) September 1998 by Mauro Marinilli
 *
 */

import javax.media.j3d.Group;
import javax.media.j3d.VirtualUniverse;
import javax.swing.tree.TreePath;
import java.io.Serializable;
import java.util.Enumeration;

public class SceneTreeModel extends AbstractTreeModel implements Serializable {

    VirtualUniverse root;

    public SceneTreeModel(VirtualUniverse vu) {
        root = vu;
    }

    public Object getRoot() {
        return root;
    }

    public Object getChild(Object parent, int index) {

        int count = 0;
        if (parent instanceof VirtualUniverse) {
            Enumeration e = ((VirtualUniverse) parent).getAllLocales();
            Object current = new Object();
            for (; e.hasMoreElements();) {
                current = e.nextElement();

                if (count++ == index) {
                    break;
                }
            }//-for
            return current;
        }

        if (parent instanceof javax.media.j3d.Locale) {
            Enumeration e = ((javax.media.j3d.Locale) parent).getAllBranchGraphs();
            Object current = new Object();
            for (; e.hasMoreElements();) {
                current = e.nextElement();

                if (count++ == index) {
                    break;
                }
            }//-for
            return current;
        }


        Enumeration e = ((Group) parent).getAllChildren();
        Object current = new Object();
        for (; e.hasMoreElements();) {
            current = e.nextElement();

            if (count++ == index) {
                break;
            }
        }//-for
        return current;
    }

    public int getChildCount(Object parent) {

        if (parent instanceof VirtualUniverse) {
            return ((VirtualUniverse) parent).numLocales();
        }

        if (parent instanceof javax.media.j3d.Locale) {
            return ((javax.media.j3d.Locale) parent).numBranchGraphs();
        }

        return ((Group) parent).numChildren();
    }

    public boolean isLeaf(Object node) {

        if (node instanceof VirtualUniverse) {
            return (((VirtualUniverse) node).numLocales() == 0);
        }

        if (node instanceof javax.media.j3d.Locale) {
            return (((javax.media.j3d.Locale) node).numBranchGraphs() == 0);
        }

        return (!(node instanceof Group));
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {

        int count = -1;
        if (parent instanceof VirtualUniverse) {

            Enumeration e = ((VirtualUniverse) parent).getAllLocales();
            Object current = new Object();
            for (; e.hasMoreElements();) {
                current = e.nextElement();
                count++;

                if (current.equals(child)) {
                    break;
                }
            }//-for
            return count;
        }

        if (parent instanceof javax.media.j3d.Locale) {
            Enumeration e = ((javax.media.j3d.Locale) parent).getAllBranchGraphs();
            Object current = new Object();
            for (; e.hasMoreElements();) {
                current = e.nextElement();
                count++;

                if (current.equals(child)) {
                    break;
                }
            }//-for
            return count;
        }

        Enumeration e = ((Group) parent).getAllChildren();
        Object current = new Object();
        for (; e.hasMoreElements();) {
            current = e.nextElement();
            count++;

            if (current.equals(child)) {
                break;
            }
        }//-for
        return count;

    }
}


