package j3d.viewer;

/*
 *
 * (c) September 1998 by Mauro Marinilli
 *
 */


import javax.media.j3d.VirtualUniverse;
import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SceneTreeFrame {
    JLabel statusLabel;

    public SceneTreeFrame(VirtualUniverse bg) {

        JFrame frame = new JFrame("Scene Tree Viewer");

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });

        SceneTreeModel model = new SceneTreeModel(bg);

        SceneTreePanel sceneTree = new SceneTreePanel(model);
        sceneTree.getTree().addTreeSelectionListener(new TreeListener(sceneTree, statusLabel));

        JScrollPane treeScroller = new JScrollPane(sceneTree);
        treeScroller.setMinimumSize(new Dimension(0, 0));

        statusLabel = new JLabel("");
        frame.getContentPane().add(treeScroller);

        frame.setSize(400, 300);
        frame.show();
    }

    protected static class TreeListener implements TreeSelectionListener {
        JLabel status;

        public TreeListener(Object o, JLabel status) {
            this.status = status;
        }

        public void valueChanged(TreeSelectionEvent e) {

//System.out.println(((Node) e.getPath().getLastPathComponent()).toString() );
        }

    }//-treeListener()

}
