package j3d.cr325.text;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import java.applet.Applet;
import java.awt.*;


public class Text3DApp extends Applet {

    public BranchGroup createSceneGraph() {
        BranchGroup bg
                = new BranchGroup();
        Transform3D t3D
                = new Transform3D();
        t3D.setTranslation(new Vector3f(0.0f, 0.0f, -3.0f));
        TransformGroup tg
                = new TransformGroup(t3D);
        bg.addChild(tg);

        TransformGroup objSpin
                = addSpinningTransformGroup(tg);

        Appearance textAppear = getTextAppearance();
        addText(textAppear, objSpin);

        addLightsBoundingSphereAndTransforms(objSpin, tg);

        return bg;
    }

    private void addLightsBoundingSphereAndTransforms(TransformGroup objSpin,
                                                      TransformGroup tg) {
        Alpha rotationAlpha = new Alpha(-1, 10000);

        RotationInterpolator ri =
                new RotationInterpolator(rotationAlpha, objSpin);

        // a bounding sphere specifies a region a behavior is active
        // create a sphere centered at the origin with radius of 100
        BoundingSphere bs
                = new BoundingSphere();
        ri.setSchedulingBounds(bs);
        objSpin.addChild(ri);
        addDirectionalLight(bs, tg);
        addAmbientLighting(bs, tg);
    }

    private void addDirectionalLight(BoundingSphere bounds, TransformGroup tg) {
        DirectionalLight lightD = new DirectionalLight();
        lightD.setInfluencingBounds(bounds);
        lightD.setDirection(new Vector3f(0.0f, 0.0f, -1.0f));
        lightD.setColor(new Color3f(1.0f, 0.0f, 1.0f));
        tg.addChild(lightD);
    }

    private void addAmbientLighting(BoundingSphere bounds, TransformGroup tg) {
        AmbientLight al = new AmbientLight();
        al.setInfluencingBounds(bounds);
        tg.addChild(al);
    }

    private void addText(Appearance textAppear, TransformGroup objSpin) {
        Font3D font3D
                = new Font3D(new Font("Helvetica", Font.PLAIN, 1),
                        new FontExtrusion());
        Text3D textGeom
                = new Text3D(font3D, new String("3DText"));

        textGeom.setAlignment(Text3D.ALIGN_CENTER);
        Shape3D textShape
                = new Shape3D();
        textShape.setGeometry(textGeom);
        textShape.setAppearance(textAppear);
        objSpin.addChild(textShape);
    }

    private TransformGroup addSpinningTransformGroup(TransformGroup tg) {
        TransformGroup objSpin = new TransformGroup();
        objSpin.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.addChild(objSpin);
        return objSpin;
    }

    private Appearance getTextAppearance() {
        Appearance textAppear = new Appearance();
        ColoringAttributes textColor = new ColoringAttributes();
        textColor.setColor(1.0f, 0.0f, 0.0f);
        textAppear.setColoringAttributes(textColor);
        textAppear.setMaterial(new Material());
        return textAppear;
    }


    public Text3DApp() {
        setLayout(new BorderLayout());
        GraphicsConfiguration gc =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas3D = new Canvas3D(gc);
        canvas3D.setStereoEnable(false);
        add("Center", canvas3D);

        BranchGroup bg = createSceneGraph();
        SimpleUniverse su = new SimpleUniverse(canvas3D);
        su.getViewingPlatform().setNominalViewingTransform();
        su.addBranchGraph(bg);
    }


    public static void main(String[] args) {
        new MainFrame(new Text3DApp(), 256, 256);
    }

} // end of class Text3DApp
