/**
 * Created by IntelliJ IDEA.
 * User: jgervasio
 * Date: Apr 20, 2004
 * Time: 12:23:04 PM
 * To change this template use Options | File Templates.
 */
package j3d.cr325.killTheStudent;

import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;

import j3d.cr325.killTheStudent.MyLevittownDoomKeyboard;

public class TheGun {

    static TransformGroup gunXfmGrp = getTransformGroup();
    static TransformGroup aimXfmGrp = new TransformGroup();
    static TransformGroup bulletXfmGrp = getTransformGroup();
    static PositionInterpolator bulletPosInt = null;
    static Alpha ballAlpha = new Alpha(1, 0, 0, 500, 0, 0);
    static BranchGroup bullet = new BranchGroup();
    private static BoundingSphere bounds
            = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);

    public static PlatformGeometry buildGunPlatform() {
        PlatformGeometry pg = new PlatformGeometry();
        BranchGroup theGun = new BranchGroup();
        Appearance gunApp = new Appearance();
        Color3f ambientColour = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(0.5f, 0.5f, 0.5f);
        float shininess = 20.0f;
        gunApp.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        TransformGroup barrel = new TransformGroup();

        Transform3D gunXfm = new Transform3D();
        Transform3D barrelXfm = new Transform3D();
        barrelXfm.set(new Vector3d(1, -2, 0));
        barrel.setTransform(barrelXfm);
        Matrix3d gunXfmMat = new Matrix3d();
        gunXfmMat.rotX(Math.PI / 2);
        gunXfm.set(gunXfmMat);
        gunXfmGrp.setTransform(gunXfm);

        barrel.addChild(new Cylinder(0.3f, 7.0f, gunApp));
        gunXfmGrp.addChild(barrel);
        theGun.addChild(gunXfmGrp);

        //pg.addChild(aim());
        pg.addChild(theGun);
        return pg;
    }

    public static BranchGroup buildGun(MyLevittownDoomKeyboard myLevittownDoomKeyboard) {
        BranchGroup theGun = new BranchGroup();
        Appearance bulletApp = new Appearance();
        Color3f ambientColour = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(0.5f, 0.5f, 0.5f);
        float shininess = 20.0f;
        bulletApp.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        TransformGroup initTransformGroup = new TransformGroup();
        TransformGroup barrel = new TransformGroup();

        //Transform3D gunXfm = new Transform3D();
        Transform3D barrelXfm = new Transform3D();
        barrelXfm.set(new Vector3d(1, 0, -5.5));
        barrel.setTransform(barrelXfm);
        //Matrix3d gunXfmMat = new Matrix3d();
        //gunXfmMat.rotX(Math.PI / 2);
        //gunXfm.set(gunXfmMat);
        //gunXfmGrp.setTransform(gunXfm);
        // lets try this..
        initTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        initTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        myLevittownDoomKeyboard.keyNavBeh.setBulletTransformGroup(initTransformGroup);

        gunXfmGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        //gunXfmGrp.addChild(new Box(1.0f, 1.0f, 0.5f, bulletApp));
        barrel.addChild(new Sphere(0.2f, bulletApp));
        gunXfmGrp.addChild(barrel);
        theGun.addChild(initTransformGroup);
        initTransformGroup.addChild(gunXfmGrp);
        return theGun;
    }

    public static Sphere getBulletBall() {
        return bulletBall;
    }

    private static Sphere bulletBall = null;

    protected static BranchGroup getBulletGroup(MyLevittownDoomKeyboard myLevittownDoomKeyboard) {
        Appearance bulletAppearance = new Appearance();
        Color3f ambientColour = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(1.0f, 0.0f, 0.0f);
        float shininess = 20.0f;
        bulletAppearance.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        bulletBall = new Sphere(0.2f, bulletAppearance);

        TransformGroup ballMovXfmGrp = new TransformGroup();
        ballMovXfmGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        ballMovXfmGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        bulletBall.setCapability(Node.ALLOW_LOCAL_TO_VWORLD_READ);
        myLevittownDoomKeyboard.keyNavBeh.setBulletTransformGroup(ballMovXfmGrp);

        ballMovXfmGrp.addChild(bulletBall);
        bullet.addChild(ballMovXfmGrp);

        //bulletXfmGrp.addChild(bulletBall);
        //bullet.addChild(bulletXfmGrp);

        return bullet;

    }

    private static TransformGroup getTransformGroup(){
        TransformGroup tg = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(TransformGroup.ALLOW_LOCAL_TO_VWORLD_READ);
        return tg;
    }

    public static BranchGroup aim() {
        BranchGroup aim = new BranchGroup();
        TransformGroup aimTg = new TransformGroup();

        Appearance aimAppearance = new Appearance();
        Color3f ambientColour = new Color3f(1.0f, 0.0f, 1.0f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 1.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(1.0f, 0.0f, 1.0f);
        float shininess = 20.0f;
        aimAppearance.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        Sphere aimSphere = new Sphere(0.3f, aimAppearance);

        Transform3D aimXfm = new Transform3D();
        aimXfm.set(new Vector3d(0, 0, -50));
        aimTg.setTransform(aimXfm);
        aimTg.addChild(aimSphere);
        aimXfmGrp.addChild(aimTg);
        aim.addChild(aimXfmGrp);

        return aim;
    }

     public static BranchGroup bullet() {
        BranchGroup bullet = new BranchGroup();
        TransformGroup bulletTg = new TransformGroup();

        Appearance bulletAppearance = new Appearance();
        Color3f ambientColour = new Color3f(1.0f, 0.0f, 1.0f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 1.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(1.0f, 0.0f, 1.0f);
        float shininess = 20.0f;
        bulletAppearance.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        Sphere bulletSphere = new Sphere(0.3f, bulletAppearance);

        Transform3D bulletXfm = new Transform3D();
        bulletXfm.set(new Vector3d(1, 0, -5.5));
        bulletTg.setTransform(bulletXfm);
        bulletTg.addChild(bulletSphere);
        bulletXfmGrp.addChild(bulletTg);
        bullet.addChild(bulletXfmGrp);
        bulletPosInt = new PositionInterpolator(ballAlpha,
                bulletTg,
                new Transform3D(), 0.0f, 50.0f);
        bulletPosInt.setSchedulingBounds(bounds);
        bullet.addChild(bulletPosInt);

        return bullet;
    }
    public static TransformGroup getGunXfmGrp() {
        return gunXfmGrp;
    }

}
