package j3d.cr325.killTheStudent;

import gui.run.RunJob;

import javax.media.j3d.*;
import javax.vecmath.Vector3d;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.util.Enumeration;


/**
 * MyKeyBehavior is a generic behavior class to take key presses and move a
 * TransformGroup through a Java3D scene. The actions resulting from the key strokes
 * are modified by using the Ctrl, Alt and Shift keys.
 * <p/>
 * (version 1.0) reconstructed class to make more generic.
 * <p/>
 * MODIFIED:
 *
 * @author Andrew AJ Cain, Swinburne University, Australia
 *         <acain@it.swin.edu.au>
 *         <p/>
 *         edited from code by:
 *         Gary S. Moss <moss@arl.mil>
 *         U. S. Army Research Laboratory
 *         <p/>
 *         CLASS NAME:
 *         MyKeyBehavior
 *         <p/>
 *         PUBLIC FEATURES:
 *         // Data
 *         <p/>
 *         // Constructors
 *         <p/>
 *         // Methods:
 *         <p/>
 *         COLLABORATORS:
 * @version 1.0, 25 September 1998 aajc
 */
public class MyKeyBehavior extends Behavior {
    protected static final double FAST_SPEED = 2.0;
    protected static final double NORMAL_SPEED = 1.0;
    protected static final double SLOW_SPEED = 0.1;

    private TransformGroup viewTransformGroup;
    private Transform3D viewTransform3D;
    private WakeupCondition keyCriterion;

    private final static double TWO_PI = (2.0 * Math.PI);
    private double eps = 32;
    private double rotateXAmount = Math.PI / eps;
    private double rotateYAmount = Math.PI / eps;
    private double rotateZAmount = Math.PI / eps;

    private double moveRate = 0.1;
    private double speed = NORMAL_SPEED;

    private int forwardKey = KeyEvent.VK_UP;
    private int backKey = KeyEvent.VK_DOWN;
    private int leftKey = KeyEvent.VK_LEFT;
    private int rightKey = KeyEvent.VK_RIGHT;
    private int spaceKey = KeyEvent.VK_SPACE;

    TransformGroup gunTransformGroup = null;
    TransformGroup bulletTransformGroup = null;
    TransformGroup targetTransformGroup = null;

    public void setTargetTransformGroup(TransformGroup targetTransformGroup) {
        this.targetTransformGroup = targetTransformGroup;
    }

    public void setGunTransformGroup() {
        this.gunTransformGroup = TheGun.getGunXfmGrp();
    }

    public void setBulletTransformGroup(TransformGroup bulletTransformGroup) {
        this.bulletTransformGroup = bulletTransformGroup;
    }

    public MyKeyBehavior(TransformGroup viewTransformGroup) {
        this.viewTransformGroup = viewTransformGroup;
        viewTransform3D = new Transform3D();

    }

    public void initialize() {
        WakeupCriterion[] keyEvents = new WakeupCriterion[2];

        keyEvents[0] = new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED);
        keyEvents[1] = new WakeupOnAWTEvent(KeyEvent.KEY_RELEASED);
        keyCriterion = new WakeupOr(keyEvents);
        wakeupOn(keyCriterion);
    }


    public void processStimulus(Enumeration criteria) {
        WakeupCriterion wakeup;
        AWTEvent[] event;

        while (criteria.hasMoreElements()) {
            wakeup = (WakeupCriterion) criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent))
                continue;

            event = ((WakeupOnAWTEvent) wakeup).getAWTEvent();
            for (int i = 0; i < event.length; i++) {
                if (event[i].getID() == KeyEvent.KEY_PRESSED) {
                    processKeyEvent((KeyEvent) event[i]);
                }
            }
        }
        wakeupOn(keyCriterion);
    }

    protected void processKeyEvent(KeyEvent ke) {

        int keycode = ke.getKeyCode();

        if (ke.isShiftDown())
            speed = FAST_SPEED;
        else
            speed = NORMAL_SPEED;
        if (ke.isAltDown())
            altMove(keycode);
        else if (ke.isControlDown())
            controlMove(keycode);
        else
            standardMove(keycode);
        //moveGun();
    }


    //moves forward backward or rotates left right
    private void standardMove(int kc) {
        System.out.println(kc);
        if (kc == forwardKey)
            moveForward();
        else if (kc == backKey)
            moveBackward();
        else if (kc == leftKey)
            rotLeft();
        else if (kc == rightKey)
            rotRight();
        else if (kc == spaceKey)
            shoot();
    }

    //moves left right, rotate up down
    protected void altMove(int keycode) {
        if (keycode == forwardKey)
            rotUp();
        else if (keycode == backKey)
            rotDown();
        else if (keycode == leftKey)
            moveLeft();
        else if (keycode == rightKey)
            moveRight();
    }

    //move up down, rot left right
    protected void controlMove(int keycode) {
        if (keycode == forwardKey)
            moveUp();
        else if (keycode == backKey)
            moveDown();
        else if (keycode == leftKey)
            rollLeft();
        else if (keycode == rightKey)
            rollRight();
    }

    private void moveForward() {
        doMove(new Vector3d(0.0, 0.0, -getMovementRate()));
    }

    private void moveBackward() {
        doMove(new Vector3d(0.0, 0.0, getMovementRate()));
    }

    private void moveLeft() {
        doMove(new Vector3d(-getMovementRate(), 0.0, 0.0));
    }

    private void moveRight() {
        doMove(new Vector3d(getMovementRate(), 0.0, 0.0));
    }

    private void moveUp() {
        doMove(new Vector3d(0.0, getMovementRate(), 0.0));
    }

    private void moveDown() {
        doMove(new Vector3d(0.0, -getMovementRate(), 0.0));
    }

    protected void rotRight() {
        doRotateY(getRotateRightAmount(), getRotateRightAmount());
    }

    protected void rotUp() {
        doRotateX(getRotateUpAmount(), getRotateUpAmount());
    }

    protected void rotLeft() {
        doRotateY(getRotateLeftAmount(), getRotateLeftAmount());
    }

    protected void rotDown() {
        doRotateX(getRotateDownAmount(), getRotateDownAmount());
    }

    protected void rollLeft() {
        doRotateZ(getRollLeftAmount(), getRollLeftAmount());
    }

    protected void rollRight() {
        doRotateZ(getRollRightAmount(), getRollRightAmount());
    }

    private void shoot() {
        MyLevittownDoomKeyboard.joeSwitch.setWhichChild(0);
        Transform3D tempT3d = new Transform3D();
        viewTransformGroup.getTransform(tempT3d);
        Vector3d v3d = new Vector3d();
        tempT3d.get(v3d);
        //System.out.println("v3d"+v3d);
        bulletTransformGroup.setTransform(tempT3d);
        i = .6;
        new RunJob(0.01, false, 75) {
            public void run() {
                bullet();
                if (closeToTarget()) {
                    System.out.println("target HIT");
                    MyLevittownDoomKeyboard.joeSwitch.setWhichChild(1);
                }

            }
        };
    }

    protected void doRotateY(double radians, double theMove) {
        viewTransformGroup.getTransform(viewTransform3D);
        Transform3D toMove = new Transform3D();
        toMove.rotY(radians);
        viewTransform3D.mul(toMove);
        viewTransformGroup.setTransform(viewTransform3D);

    }

    protected void doRotateX(double radians, double theMove) {
        viewTransformGroup.getTransform(viewTransform3D);
        Transform3D toMove = new Transform3D();
        toMove.rotX(radians);
        viewTransform3D.mul(toMove);
        viewTransformGroup.setTransform(viewTransform3D);
    }

    protected void doRotateZ(double radians, double theMove) {
        viewTransformGroup.getTransform(viewTransform3D);
        Transform3D toMove = new Transform3D();
        toMove.rotZ(radians);
        viewTransform3D.mul(toMove);
        viewTransformGroup.setTransform(viewTransform3D);
    }

    protected void doMove(Vector3d theMove) {
        viewTransformGroup.getTransform(viewTransform3D);
        Transform3D theMoveTransform3d = new Transform3D();
        theMoveTransform3d.setTranslation(theMove);
        viewTransform3D.mul(theMoveTransform3d);
        // this is where you need to set the gun
        // transform group too:
        // gunTransformGroup.setTransform(transform3D);
        viewTransformGroup.setTransform(viewTransform3D);

    }

    private double i = .6;

    private void bullet() {
        Toolkit.getDefaultToolkit().beep();
        Transform3D tempT3d = new Transform3D();
        bulletTransformGroup.getTransform(tempT3d);
        Transform3D toMove = new Transform3D();
        Vector3d bulletMove = new Vector3d(i, 1, 1);
        if (i > 0)
            i = i - .2;

        bulletMove.add(new Vector3d(0, -1, -2));
        toMove.setTranslation(bulletMove);

        tempT3d.mul(toMove);
        bulletTransformGroup.setTransform(tempT3d);
    }

    private boolean closeToTarget() {
        double sqLen = getBulletTargetDistance();
        if (sqLen < 2) return true;
        return false;
    }

    private double getBulletTargetDistance() {
        Vector3d targetVector = new Vector3d();   // location of target
        Vector3d bulletVector = new Vector3d();
        Transform3D bulletTransform = new Transform3D();
        TheGun.getBulletBall().getLocalToVworld(bulletTransform);
        bulletTransform.get(bulletVector);
        //System.out.print("bv "+bulletVector + ",");
        Transform3D targetTransform = new Transform3D();
        j3d.cr325.killTheStudent.Utils.getSphere().getLocalToVworld(targetTransform);
        targetTransform.get(targetVector);
        //System.out.println(targetVector);
        bulletVector.sub(targetVector);
        //System.out.println(bulletVector);
        double sqLen = Math.sqrt(bulletVector.lengthSquared());
        //System.out.println(sqLen);
        return sqLen;
    }


    protected double getMovementRate() {
        return moveRate * speed;
    }

    protected double getRollLeftAmount() {
        return rotateZAmount * speed;
    }

    protected double getRollRightAmount() {
        return -rotateZAmount * speed;
    }

    protected double getRotateUpAmount() {
        return rotateYAmount * speed;
    }

    protected double getRotateDownAmount() {
        return -rotateYAmount * speed;
    }

    protected double getRotateLeftAmount() {
        return rotateYAmount * speed;
    }

    protected double getRotateRightAmount() {
        return -rotateYAmount * speed;
    }

    public void setRotateXAmount(double radians) {
        rotateXAmount = radians;
    }

    public void setRotateYAmount(double radians) {
        rotateYAmount = radians;
    }

    public void setRotateZAmount(double radians) {
        rotateZAmount = radians;
    }

    public void setMovementRate(double meters) {
        moveRate = meters; // Travel rate in meters/frame
    }

    public void setForwardKey(int key) {
        forwardKey = key;
    }

    public void setBackKey(int key) {
        backKey = key;
    }

    public void setLeftKey(int key) {
        leftKey = key;
    }

    public void setRightKey(int key) {
        rightKey = key;
    }
}
