/**
 * Created by IntelliJ IDEA.
 * User: jgervasio
 * Date: Apr 20, 2004
 * Time: 12:18:35 PM
 * To change this template use Options | File Templates.
 */
package j3d.cr325.killTheStudent;

import j3d.cr325.killTheStudent.MyLevittownDoomKeyboard;

import javax.media.j3d.*;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Point3d;

public class JoeSphere {

    public static BranchGroup getLiveJoeSphere(Switch joeSwitch1, String img) {
        BranchGroup theJoeSphere = new BranchGroup();
        joeSwitch1.addChild(Utils.getTextureSphere(1.5, 0, 1.125, img));
        return theJoeSphere;
    }

    public static BranchGroup getDeadJoeSphere(String img) {
        BranchGroup theJoeSphere = new BranchGroup();
        theJoeSphere = (Utils.getTextureSphere(1.5, 0, 1.125, img));
        return theJoeSphere;
    }

    public static Switch getJoeSwitch() {
        Switch s = new Switch(0);
        s.setCapability(Switch.ALLOW_SWITCH_WRITE);
        return s;
    }

    public static BranchGroup getJoeGroup(MyLevittownDoomKeyboard myLevittownDoomKeyboard) {
        BranchGroup theJoeSphere = new BranchGroup();

        BranchGroup s1 = getDeadJoeSphere("shuttle\\aw673.jpg");
        BranchGroup s2 = getLiveJoeSphere(myLevittownDoomKeyboard.joeSwitch, "gifs\\animation4.gif");

        TransformGroup joeRotXfmGrp = new TransformGroup();
        Transform3D joeRotXfm = new Transform3D();
        Matrix3d joeRotMat = new Matrix3d();
        joeRotMat.rotY(Math.PI / 2);
        joeRotXfm.set(joeRotMat, new Vector3d(0.0, 0.0, -30.0), 1.0);
        joeRotXfmGrp.setTransform(joeRotXfm);
        joeRotXfmGrp.addChild(myLevittownDoomKeyboard.joeSwitch);

        myLevittownDoomKeyboard.joeSwitch.addChild(s1);
        myLevittownDoomKeyboard.joeSwitch.addChild(s2);

        TransformGroup joeMovXfmGrp = new TransformGroup();
        joeMovXfmGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        joeMovXfmGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

        myLevittownDoomKeyboard.keyNavBeh.setTargetTransformGroup(joeMovXfmGrp);
        joeMovXfmGrp.addChild(joeRotXfmGrp);

        Transform3D axis = new Transform3D();
        PositionInterpolator moveJoe =
                new PositionInterpolator(myLevittownDoomKeyboard.joeAlpha,
                        joeMovXfmGrp,
                        axis,
                        -50.0f, 50.0f);
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 200);
        moveJoe.setSchedulingBounds(bs);
        theJoeSphere.addChild(moveJoe);
        theJoeSphere.addChild(joeMovXfmGrp);
        return theJoeSphere;
    }
}
