/**
 * Created by IntelliJ IDEA.
 * User: jgervasio
 * Date: Apr 20, 2004
 * Time: 12:00:50 PM
 * To change this template use Options | File Templates.
 */
package j3d.cr325.killTheStudent;

import j3d.cr325.killTheStudent.MyLevittownDoomKeyboard;
import j3d.cr325.Shapes;

import javax.vecmath.Vector3f;
import javax.media.j3d.*;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Primitive;

public class AddSceneGeometry {
    public static void addTrees(MyLevittownDoomKeyboard myLevittownDoomKeyboard, Vector3f translate,
                          Transform3D t3D,
                          BoundingSphere bSphere,
                          BranchGroup bg) {
        SharedGroup share = new SharedGroup();
        share.addChild(Shapes.getTrees());

        float position[][] = {{0.0f, 0f, -3.0f},
                              {6.0f, 0f, 0.0f},
                              {6.0f, 0f, 6.0f},
                              {3.0f, 0f, -10.0f},
                              {13.0f, 0f, -30.0f},
                              {-13.0f, 0f, 30.0f},
                              {-13.0f, 0f, 23.0f},
                              {13.0f, 0f, 3.0f}};

        placeStuff(position, translate, t3D, bSphere, bg, share);
    }

    public static void addTanks(MyLevittownDoomKeyboard myLevittownDoomKeyboard, Vector3f translate,
                          Transform3D t3D,
                          BoundingSphere bSphere,
                          BranchGroup bg) {
        SharedGroup share = new SharedGroup();
        //share.addChild(Tetrahedron.createTetrahedronBranchGroup());

        float position[][] = {{4.0f, 0.5f, -3.0f},
                              {2.0f, 0.5f, 0.0f},
                              {2.0f, 0.5f, 6.0f},
                              {7.0f, 0.5f, -10.0f},
                              {20.0f, 0.5f, -30.0f},
                              {-11.0f, 0.5f, 30.0f},
                              {-18.0f, 0.5f, 23.0f},
                              {16.0f, 0.5f, 3.0f}};

        placeStuff(position, translate, t3D, bSphere, bg, share);
    }

    public static void addHouses(MyLevittownDoomKeyboard myLevittownDoomKeyboard, Vector3f translate,
                           Transform3D t3D,
                           BoundingSphere bSphere,
                           BranchGroup bg) {
        SharedGroup share = new SharedGroup();

        share.addChild(Shapes.getHouses());

        float position[][] = {{0.0f, 0f, -2.0f},
                              {3.0f, 0f, 0.0f},
                              {3.0f, 0f, 4.0f},
                              {4.0f, 0f, -8.0f},
                              {6.0f, 0f, -25.0f},
                              {-6.0f, 0f, 25.0f},
                              {-6.0f, 0f, 15.0f},
                              {6.0f, 0f, 1.0f}};

        placeStuff(position, translate, t3D, bSphere, bg, share);
    }

    public static BranchGroup createBackground(MyLevittownDoomKeyboard levitown) {
        // create a parent BranchGroup for the Background
        BranchGroup backgroundGroup = new BranchGroup();

        // create a new Background node
        Background back = new Background();

        // set the range of influence of the background
        back.setApplicationBounds(levitown.getBackgroundBoundingSphere());

        // create a BranchGroup that will hold
        // our Sphere geometry
        BranchGroup bgGeometry = new BranchGroup();

        // create the Sphere geometry with radius 1.0
        // we tell the Sphere to generate texture coordinates
        // to enable the texture image to be rendered
        // and because we are *inside* the Sphere we have to generate
        // Normal coordinates inwards or the Sphere will not be visible.
        Appearance appearance = new Appearance();
        appearance.setTexture(Utils.getMandleTexture(640, 480));
        Sphere sphere = new Sphere(0.50f,
                Primitive.GENERATE_TEXTURE_COORDS |
                Primitive.GENERATE_NORMALS_INWARD,
                appearance);

        // start wiring everything together
        // add the Sphere to its parent BranchGroup
        bgGeometry.addChild(sphere);

        // assign the BranchGroup to the Background as geometry.
        back.setGeometry(bgGeometry);

        // add the Background node to its parent BranchGroup
        backgroundGroup.addChild(back);

        return backgroundGroup;
    }

    public static void placeStuff(float[][] position,
                            Vector3f translate,
                            Transform3D t3D,
                            BoundingSphere bSphere,
                            BranchGroup bg,
                            SharedGroup share) {
        TransformGroup TGT;
        TransformGroup TGR;
        Billboard billboard;
        for (int i = 0; i < position.length; i++) {
            translate.set(position[i]);
            t3D.setTranslation(translate);
            TGT = new TransformGroup(t3D);
            TGR = new TransformGroup();
            TGR.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
            billboard = new Billboard(TGR);
            billboard.setSchedulingBounds(bSphere);
            billboard.setAlignmentMode(Billboard.ROTATE_ABOUT_POINT);
            bg.addChild(TGT);
            bg.addChild(billboard);
            TGT.addChild(TGR);
            TGR.addChild(new Link(share));
        }
    }
}
