package j3d.cr325;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;
import j3d.Utils;

import javax.media.j3d.*;
import javax.vecmath.Point3d;
import java.applet.Applet;
import java.awt.*;

/**
 * Create a simple game, to shoot the students.
 */
public final class SimpleGame extends Applet {

    private final BoundingSphere bsBounds
            = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    /**
     * Alpha used to drive the target animation.
     */
    private final Alpha targetAlpha = new Alpha(-1, 0, 0, 3000, 0, 0);
    /**
     * Used to drive the bullet animation.
     */
    private BulletBehavior bb = new BulletBehavior();


    /**
     * Used to rotate the gun.
     */
    private final TransformGroup gunTransformGroup = Shapes.getReadWriteTransformGroup();

    private BranchGroup getContentBranch() {
        final BranchGroup rootBranchGroup = new BranchGroup();
        rootBranchGroup.addChild(Shapes.getTreeBranchGroup());
        rootBranchGroup.addChild(Shapes.getHousesBranchGroup());
        rootBranchGroup.addChild(Shapes.getBackgroundBranchGroup());
        final Node theTarget = Target.getTargetGroup();
        rootBranchGroup.addChild(theTarget);
        rootBranchGroup.addChild(Bullet.getBulletGroup(bb));
        rootBranchGroup.addChild(new TargetBehavior(theTarget,
                Target.getTargetSwitch(),
                targetAlpha,
                getBsBounds()));
        rootBranchGroup.addChild(new GunBehavior(bb,
                gunTransformGroup,
                getBsBounds()));
        rootBranchGroup.addChild(Shapes.getGunBranchGroup(gunTransformGroup));
        final BoundingSphere bsBounds = getBsBounds();
        Utils.addLights(bsBounds, rootBranchGroup);
        return rootBranchGroup;
    }

    private SimpleGame() {
        setLayout(new BorderLayout());
        final GraphicsConfiguration gc =
                SimpleUniverse.getPreferredConfiguration();
        final Canvas3D c3d
                = new Canvas3D(gc);
        final Locale l
                = new Locale(new VirtualUniverse());
        l.addBranchGraph(Shapes.buildViewBranch(c3d));
        l.addBranchGraph(getContentBranch());
        setLayout(new BorderLayout());
        add(BorderLayout.CENTER, c3d);
    }

    /**
     * Ignore args.
     *
     * @param args ignored.
     */
    public static void main(final String[] args) {
        new MainFrame(createSimpleGame(), 400, 400);
    }

    private static SimpleGame createSimpleGame() {
        return new SimpleGame();
    }

    private BoundingSphere getBsBounds() {
        return bsBounds;
    }

}
