/**
 * Created by IntelliJ IDEA.
 * User: jgervasio
 * Date: Feb 23, 2004
 * Time: 12:11:58 PM
 * To change this template use Options | File Templates.
 */
package j3d.cr325;


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import j3d.Utils;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.applet.Applet;
import java.awt.*;


//   BillboardApp renders a simple landscape with billboard animated trees

public class Levitown extends Applet {
    private BoundingSphere bsBounds
            = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    PositionInterpolator bulletInterpolator = null;
    Alpha bulletAlpha = new Alpha(1, 0, 0, 500, 0, 0);

    public Levitown() {
        Canvas3D c3d
                = Utils.getCanvas3D(this);
        Locale l
                = new Locale(new VirtualUniverse());
        l.addBranchGraph(buildViewBranch(c3d));
        TransformGroup tg = Shapes.getReadWriteTransformGroup();
        l.addBranchGraph(getSceneBranchGroup(tg));
        setLayout(new BorderLayout());
        add("Center", c3d);

    }


    protected static BranchGroup buildViewBranch(Canvas3D c) {
        BranchGroup viewBranch = new BranchGroup();


        ViewPlatform myViewPlatform = new ViewPlatform();
        TransformGroup viewXfmGroup = getViewTransformGroup(getViewTilt());
        viewXfmGroup.addChild(myViewPlatform);
        viewBranch.addChild(viewXfmGroup);
        addKeyNavigation(viewXfmGroup, viewBranch);
        View myView = new View();
        myView.addCanvas3D(c);
        myView.attachViewPlatform(myViewPlatform);
        myView.setPhysicalBody(new PhysicalBody());
        myView.setPhysicalEnvironment(new PhysicalEnvironment());
        return viewBranch;
    }

    private static void addKeyNavigation(TransformGroup viewXfmGroup, BranchGroup viewBranch) {
        KeyNavigatorBehavior knb = new KeyNavigatorBehavior(viewXfmGroup);
        knb.setSchedulingBounds(new BoundingSphere());
        viewBranch.addChild(knb);
    }

    private static Matrix3d getViewTilt() {
        Matrix3d viewTilt = new Matrix3d();
        viewTilt.rotX(Math.PI / -6);
        return viewTilt;
    }

    private static TransformGroup getViewTransformGroup(Matrix3d viewTilt) {
        Transform3D t3d = new Transform3D();
        t3d.set(viewTilt, new Vector3d(0.0, 10.0, 10.0), 1.0);
        TransformGroup viewXfmGroup
                = new TransformGroup(t3d);
        return viewXfmGroup;
    }

    public BranchGroup getSceneBranchGroup(TransformGroup tg) {
        BranchGroup bg = Shapes.getReadWriteBranchGroup();

        Vector3f translate = new Vector3f();
        Transform3D t3d = new Transform3D();

        BoundingSphere bs = new BoundingSphere();
        bs.setRadius(10);

        bg.addChild(Shapes.getLand());
        bg.addChild(Shapes.getTreeBranchGroup());
        bg.addChild(Shapes.getHousesBranchGroup());
        bg.addChild(Shapes.getBackgroundBranchGroup());

        raiseViewAboveGround(translate, t3d, tg);
        //KeyBehavior keyNavBeh = new KeyBehavior( tg);
        KeyNavigatorBehavior keyNavBeh = new KeyNavigatorBehavior(tg);
        keyNavBeh.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000.0));
        bg.addChild(keyNavBeh);

        bg.addChild(Target.getTargetGroup());
        BranchGroup gunBg = buildGun();
        Node theBulletNode = getBulletGroup();
        bg.addChild(theBulletNode);
        bg.addChild(gunBg);
        return bg;
    } // end of CreateSceneGraph method of BillboardApp

    protected BranchGroup getBulletGroup() {
        BranchGroup bullet = new BranchGroup();

        Appearance bulletAppearance = new Appearance();
        Color3f ambientColour = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(1.0f, 0.0f, 0.0f);
        float shininess = 20.0f;
        bulletAppearance.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        Sphere ball = new Sphere(0.2f, bulletAppearance);

        TransformGroup ballMovXfmGrp = new TransformGroup();
        ballMovXfmGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        ballMovXfmGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        ballMovXfmGrp.addChild(ball);
        bullet.addChild(ballMovXfmGrp);


        bulletInterpolator = new PositionInterpolator(bulletAlpha,
                ballMovXfmGrp,
                new Transform3D(), 0.0f, 50.0f);
        bulletInterpolator.setSchedulingBounds(getBsBounds());
        bullet.addChild(bulletInterpolator);

        return bullet;

    }

    /**
     * This builds the gun geometry.
     * It uses box and cylinder primitives and sets up a
     * transform group so that we can rotate the gun.
     */
    protected BranchGroup buildGun() {

        Appearance gunApp = new Appearance();
        Color3f ambientColour = new Color3f(0.5f, 0.5f, 0.5f);
        Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f diffuseColour = new Color3f(0.5f, 0.5f, 0.5f);
        float shininess = 20.0f;
        gunApp.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));
        TransformGroup init = Shapes.getReadWriteTransformGroup();
        TransformGroup barrel = Shapes.getReadWriteTransformGroup();
        Transform3D gunXfm = new Transform3D();
        Transform3D barrelXfm = new Transform3D();
        barrelXfm.set(new Vector3d(0.0, -2.0, 0.0));
        barrel.setTransform(barrelXfm);
        Matrix3d gunXfmMat = new Matrix3d();
        gunXfmMat.rotX(Math.PI / 2);
        Vector3d gunTranslation = new Vector3d(0.0, -.250, -5);
        gunXfm.set(gunXfmMat, gunTranslation, 1.0);
        init.setTransform(gunXfm);

        gunXfmGrp.addChild(new Box(1.0f, 1.0f, 0.5f, gunApp));
        barrel.addChild(new Cylinder(0.3f, 4.0f, gunApp));
        gunXfmGrp.addChild(barrel);

        BranchGroup gunBranchGroup = Shapes.getReadWriteBranchGroup();
        gunBranchGroup.addChild(init);
        init.addChild(addKeyNavigatorBehavior(init));

        return gunBranchGroup;
    }

    private KeyNavigatorBehavior addKeyNavigatorBehavior(TransformGroup init) {
        KeyNavigatorBehavior knb = new KeyNavigatorBehavior(gunXfmGrp);
        knb.setSchedulingBounds(new BoundingSphere());
        init.addChild(gunXfmGrp);
        return knb;
    }

    TransformGroup gunXfmGrp = Shapes.getReadWriteTransformGroup();

    private void raiseViewAboveGround(Vector3f translate, Transform3D t3D, TransformGroup tg) {
        translate.set(0.0f, 0.3f, 0.0f);
        t3D.setTranslation(translate);
        tg.setTransform(t3D);
    }


    public BoundingSphere getBsBounds() {
        return bsBounds;
    }

    public static void main(String[] args) {
        new MainFrame(new Levitown(), 256, 256);
    } // end of main (method of BillboardApp)
}
