package j3d.cr325;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Alpha;
import javax.media.j3d.PositionInterpolator;
import javax.vecmath.Point3d;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Apr 6, 2004
 * Time: 3:49:26 PM
 */
public class BulletBehavior {
       private final BoundingSphere bsBounds
         = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
     private final Alpha bulletAlpha = new Alpha(1, 0, 0, 500, 0, 0);

     public Alpha getAlpha() {
         return bulletAlpha;
     }

     /**
      * Used to move the bullet.
      */
     private PositionInterpolator bulletInterpolator = null;

     public PositionInterpolator getBulletInterpolator() {
         return bulletInterpolator;
     }

     public void setBulletInterpolator(PositionInterpolator bulletInterpolator) {
         this.bulletInterpolator = bulletInterpolator;
         bulletInterpolator.setSchedulingBounds(bsBounds);
     }
 }
