package j3d.cr325;

import j3d.cr325.BulletBehavior;

import javax.media.j3d.*;
import javax.vecmath.Color3f;

import com.sun.j3d.utils.geometry.Sphere;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Apr 6, 2004
 * Time: 3:53:26 PM
 */
public class Bullet {
    /**
     * This builds the ball that acts as the bullet for our gun.
     * The ball is created from a sphere primitive, and a transform
     * group and interpolator are added so that we can 'fire' the
     * bullet.
     *
     * @return BranchGroup that is the root of the ball branch.
     * @param simpleGame
     */
    public static BranchGroup getBulletGroup(BulletBehavior bb) {
        final BranchGroup bulletBranchGroup = new BranchGroup();

        final Appearance bulletAppearance = new Appearance();
        final Color3f ambientColour = new Color3f(1.0f, 0.0f, 0.0f);
        final Color3f emissiveColour = new Color3f(0.0f, 0.0f, 0.0f);
        final Color3f specularColour = new Color3f(1.0f, 1.0f, 1.0f);
        final Color3f diffuseColour = new Color3f(1.0f, 0.0f, 0.0f);
        final float shininess = 20.0f;
        bulletAppearance.setMaterial(new Material(ambientColour, emissiveColour,
                diffuseColour, specularColour, shininess));

        final Sphere bulletSphere = new Sphere(0.2f, bulletAppearance);

        final TransformGroup bulletMoveTransformGroup = new TransformGroup();
        bulletMoveTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        bulletMoveTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        bulletMoveTransformGroup.addChild(bulletSphere);
        bulletBranchGroup.addChild(bulletMoveTransformGroup);


        bb.setBulletInterpolator( new PositionInterpolator(bb.getAlpha(),
                bulletMoveTransformGroup,
                new Transform3D(), 0.0f, 50.0f));

        bulletBranchGroup.addChild(bb.getBulletInterpolator());

        return bulletBranchGroup;

    }
}
