/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Mar 3, 2004
 * Time: 12:37:33 PM
 * To change this template use Options | File Templates.
 */
package j3d;

import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import ip.raul.Fractals;
import j2d.ImageUtils;
import utils.SystemUtils;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import java.awt.*;
import java.io.File;

public class Utils {
    private static String userDir = SystemUtils.getUserDir();
    private static final String pathSep = SystemUtils.getDirectorySeparator();
    private static String dataDirectory =
            userDir + pathSep + "data" + pathSep;

    private static String imageDirectory
            = dataDirectory + "images" + pathSep;

    public static void main(String[] args) {
        System.out.println("checking images directory:" + imageDirectory);
        boolean b = checkImagesDirectory();
        System.out.println("found directory=" + b);
    }

    public static boolean checkImagesDirectory() {
        File f = new File(dataDirectory);
        if (f.exists()) return true;
        f = futils.Futil.getReadDirFile("please locate:" + dataDirectory);
        dataDirectory = f.toString();
        return checkImagesDirectory();
    }

    public static Texture getTexture(Component c) {
        File f = futils.Futil.getReadFile("select env map");
        // load a texture image using the Java 3D texture loader
        Texture tex = new TextureLoader(f.toString(), c).getTexture();
        return tex;
    }

    public static Appearance getAppearance(Component c) {
        Appearance app = new Appearance();
        // apply the texture to the Appearance
        app.setTexture(getTexture(c));
        return app;
    }

    public static Texture getMandleTexture(int w, int h) {
        TextureLoader tl = new TextureLoader(ImageUtils.getBufferedImage(Fractals.getMandelbrot(w, h)));
        return tl.getTexture();
    }

    public static Texture getTexture(Image img) {
        return new TextureLoader(ImageUtils.getBufferedImage(img)).getTexture();
    }

    public static Background getMandlebrotBackground(int w, int h) {
        return new Background(new ImageComponent2D(ImageComponent2D.FORMAT_RGBA,
                ImageUtils.getBufferedImage(Fractals.getMandelbrot(w, h))));
    }


    public static void addKeyboardNavigation(TransformGroup tg, BranchGroup bg) {
        KeyNavigatorBehavior keyNavBeh = new KeyNavigatorBehavior(tg);
        keyNavBeh.setSchedulingBounds(new BoundingSphere(new Point3d(), 10000.0));
        bg.addChild(keyNavBeh);
    }

    /**
     * SetLayout to border layout and
     *
     * @param c
     * @return a Canvas3D based on the container
     */
    public static Canvas3D getCanvas3D(Container c) {
        c.setLayout(new BorderLayout());
        GraphicsConfiguration gc =
                SimpleUniverse.getPreferredConfiguration();
        return new Canvas3D(gc);
    }

    public static void addLights(BranchGroup bg) {
        addLights(new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0), bg);
    }

    /**
     * This adds some lights to the content branch of the scene graph.
     *
     * @param bounds1
     * @param b       The BranchGroup to add the lights to.
     */
    public static void addLights(BoundingSphere bounds1,
                                 BranchGroup b) {
        Color3f ambLightColour = new Color3f(0.5f, 0.5f, 0.5f);
        AmbientLight ambLight = new AmbientLight(ambLightColour);
        ambLight.setInfluencingBounds(bounds1);
        Color3f dirLightColour = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f dirLightDir = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight dirLight = new DirectionalLight(dirLightColour, dirLightDir);
        dirLight.setInfluencingBounds(bounds1);
        b.addChild(ambLight);
        b.addChild(dirLight);
    }

    public static Background getImageBackground(String fileName) {
        checkImagesDirectory();
        Image img = ImageUtils.getImage(imageDirectory + fileName);
        return new Background(new ImageComponent2D(ImageComponent2D.FORMAT_RGB,
                ImageUtils.getBufferedImage(img)));
    }

    public static Appearance getImageAppearance(String fileName) {

        Appearance app = new Appearance();
        checkImagesDirectory();
        Image image = ImageUtils.getImage(imageDirectory + fileName);
        app.setTexture(getTexture(image));
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);

        app.setMaterial(new Material(white, black, white,
                white, 1.0f));
        return app;
    }

    public static Appearance getMandelbrotAppearance(int w, int h) {
        Appearance app = new Appearance();
        app.setTexture(getMandleTexture(w, h));
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);

        app.setMaterial(new Material(white, black, white,
                white, 1.0f));
        return app;
    }

    public static BranchGroup getTextureSphere(double scale,
                                               double xpos, double ypos,
                                               String fileName) {
        BranchGroup objRoot = new BranchGroup();
        BoundingSphere bounds =
                new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds(bounds);
        objRoot.addChild(bg);


        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);

        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds(bounds);
        getDirectionLight(bounds, objRoot);
        objRoot.addChild(aLgt);

        Appearance app = //Utils.getMandelbrotAppearance(400, 400);
                getImageAppearance(fileName);
        objRoot.addChild(createObject(app, scale, xpos, ypos));
        objRoot.compile();
        return objRoot;
    }

    public static void getDirectionLight(BoundingSphere bounds, BranchGroup objRoot) {
        Vector3f lDir1 = new Vector3f(-1.0f, -0.5f, -1.0f);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds(bounds);
        objRoot.addChild(lgt1);
    }

    public static Group createObject(Appearance app,
                                     double scale,
                                     double xpos, double ypos) {
        Transform3D t = new Transform3D();
        t.set(scale, new Vector3d(xpos, ypos, 0.0));
        TransformGroup objTrans = new TransformGroup(t);
        TransformGroup spinTg = new TransformGroup();
        spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        Primitive obj = new Sphere(1.0f,
                Sphere.GENERATE_NORMALS |
                Sphere.GENERATE_TEXTURE_COORDS, 28, app);
        //Primitive obj = new Box(1.0f,
        //        (float) xpos, (float) ypos,
        //        Box.GENERATE_NORMALS | Box.GENERATE_TEXTURE_COORDS,
        //        app);

        spinTg.addChild(obj);
        Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
                0, 0,
                10000, 0, 0,
                0, 0, 0);
        RotationInterpolator rotator =
                new RotationInterpolator(rotationAlpha, spinTg);
        BoundingSphere bounds =
                new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds(bounds);
        objTrans.addChild(rotator);
        objTrans.addChild(spinTg);
        return objTrans;
    }

    public static void addMotion(Alpha a,
                                 TransformGroup objectsXformGroup,
                                 BranchGroup theBgToMove) {
        Transform3D axis = new Transform3D();
        PositionInterpolator piObj =
                new PositionInterpolator(a,
                        objectsXformGroup,
                        axis,
                        -30.0f, 30.0f);
        Bounds bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        piObj.setSchedulingBounds(bs);
        theBgToMove.addChild(piObj);
        theBgToMove.addChild(objectsXformGroup);
    }

    public static BranchGroup getBranchGroup() {
        BranchGroup bg = new BranchGroup();
        bg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        bg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        return bg;
    }

    public static ViewPlatform getViewPlatform() {
        ViewPlatform vp = new ViewPlatform();
        vp.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        vp.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        return vp;
    }

    public static TransformGroup getTransformGroup(Transform3D t3d) {
        TransformGroup tg = new TransformGroup(t3d);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        return tg;
    }

    public static TransformGroup getTransformGroup() {
        TransformGroup tg = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        tg.setCapability(TransformGroup.ALLOW_LOCAL_TO_VWORLD_READ); 
        return tg;
    }
}
