package j3d;


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.*;
import java.applet.Applet;
import java.awt.*;

public class TwistStripApp extends Applet {

    /////////////////////////////////////////////////
    //
    // create scene graph branch group
    //
    public BranchGroup createSceneGraph() {

        BranchGroup contentRoot = new BranchGroup();

        // Create the transform group node and initialize it to the
        // identity. Add it to the root of the subgraph.
        TransformGroup objSpin = new TransformGroup();
        objSpin.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        contentRoot.addChild(objSpin);

        Shape3D twist = new Twist();
        objSpin.addChild(twist);

        // Duplicate the twist strip geometry and set the
        // appearance of the new Shape3D object to line mode
        // without culling.
        // Add the POLYGON_FILLED and POLYGON_LINE strips
        // in the scene graph at the same point.
        // This will show the triangles of the original Mobius strip that
        // are clipped.  The PolygonOffset is set to prevent stitching.
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCullFace(PolygonAttributes.CULL_NONE);
        polyAttrib.setPolygonMode(PolygonAttributes.POLYGON_LINE);
        polyAttrib.setPolygonOffset(0.001f);
        Appearance polyAppear = new Appearance();
        polyAppear.setPolygonAttributes(polyAttrib);
        objSpin.addChild(new Shape3D(twist.getGeometry(), polyAppear));

        Alpha rotationAlpha = new Alpha(-1, 1600);

        RotationInterpolator rotator =
                new RotationInterpolator(rotationAlpha, objSpin);

        // a bounding sphere specifies a region a behavior is active
        // create a sphere centered at the origin with radius of 1
        BoundingSphere bounds = new BoundingSphere();
        rotator.setSchedulingBounds(bounds);
        objSpin.addChild(rotator);
        addBackground(bounds, contentRoot);

        // Let Java 3D perform optimizations on this scene graph.
        contentRoot.compile();

        return contentRoot;
    } // end of CreateSceneGraph method of TwistStripApp

    private void addBackground(BoundingSphere bounds, BranchGroup contentRoot) {
        Background background =
                j3d.Utils.getMandlebrotBackground(256, 256);
        background.setApplicationBounds(bounds);
        contentRoot.addChild(background);
    }

    // Create a simple scene and attach it to the virtual universe

    public TwistStripApp() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas3D = new Canvas3D(config);
        add("Center", canvas3D);

        BranchGroup scene = createSceneGraph();

        // SimpleUniverse is a Convenience Utility class
        SimpleUniverse su = new SimpleUniverse(canvas3D);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(scene);

    } // end of TwistStripApp constructor

    //  The following method allows this to be run as an application

    public static void main(String[] args) {

        new MainFrame(new TwistStripApp(), 256, 256);
    } // end of main method of TwistStripApp

} // end of class TwistStripApp
