/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 5:12:56 PM
 */
package j2d.hpp;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.ImageProcessListener;

import javax.swing.*;
import java.awt.*;

public class HistogramPanel
        extends JPanel {

    ImageProcessListener ipl = null;


    public HistogramPanel(ImageProcessListener _ipl) {
        ipl = _ipl;

        setLayout(new FlowLayout());
        add(new RunButton("unahe") {
            public void run() {
                updateImage();
            }
        });
        add(new RunSlider(1, 100, 50) {
            public void run() {
                enahe(getValue());
            }
        });

    }

    private void enahe(double alpha) {
        EnaheFilter e = new EnaheFilter(ipl.getImage(), alpha / 10.0);
        ipl.update(new HppFilterImageProcessor(e));
    }

    private void updateImage() {
        EqualizationFilter cf = new EqualizationFilter(
                ipl.getImage());
        ipl.update(new HppFilterImageProcessor(cf));

    }

}
