package j2d.filters;

import j2d.ImageUtils;
import ip.transforms.Gauss;
import j2d.ImageProcessorInterface;

import java.awt.*;

import utils.Timer;


public class GaussianSmoothingProcessor
        implements ImageProcessorInterface {

    private int kernelWidth;
    private double sigma;


    public GaussianSmoothingProcessor(
            int _kernelWidth,
            double _sigma) {

        kernelWidth = _kernelWidth;
        sigma = _sigma;
    }

    public Image process(Image img) {
        Timer t = new Timer();
        t.start();
        Image i = gaussianSmooth(img);
        t.stop();
        double f = t.getElapsedTime();
        System.out.println(
                "did convolution with "
                +kernelWidth
                + "kernel in "
                + f
                +" seconds.");
        return i;

    }

    private Image gaussianSmooth(Image img) {
        return ImageUtils.convolution(img,
                Gauss.getGaussKernel(
                        kernelWidth,
                        kernelWidth,
                        sigma));
    }

}

