package j2d.edge;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.*;
import j2d.animation.AnimationDialog;

import javax.swing.*;
import java.awt.*;


public class MehrotraAndZhangPanel extends JPanel {


    private int kernelWidth = 15;
    private double h = 2.0;

    ImageProcessListener ipl = null;

    /**Construct the frame*/
    public MehrotraAndZhangPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    /**Component initialization*/
    private void initGuiElements() {
        setLayout(new FlowLayout());

        add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        add(new JLabel("kernel width"));
        add(new RunSlider(4, 19, 15) {
            public void run() {
                kernelWidth = getValue();
                updateImage();
            }
        });
        add(new RunButton("comparison") {
            public void run() {
                ImageProcessorFactory ipf =
                        new MehrotraAndZhangProcessor(
                                kernelWidth,
                                h);
                ComparisonUtils.showComparisonFrame(
                        getComparisonPanel(ipf));
            }
        });
        add(new RunButton("save gifs") {
            public void run() {

                saveGifs();
            }
        });
    }

    private void saveGifs() {
        ImageProcessorFactory ipf =
                new AnimationProcessor();

        ImageBeanInterface origImagePanel =
                (ImageBeanInterface) ipl;
        new AnimationDialog(origImagePanel.getImage(),
                ipf);
    }

    public JPanel getComparisonPanel(ImageProcessorFactory ipf) {

        ImageBeanInterface origImagePanel =
                (ImageBeanInterface) ipl;
        Image sourceImage = origImagePanel.getImage();
        return ComparisonUtils.getComparisonPanel(sourceImage, ipf);

    }

    public void updateImage() {
        try {
            ipl.update(new MehrotraAndZhangProcessor(
                    kernelWidth,
                    h
            ));
        } catch (Exception e) {
            System.out.println("ER!:kernelWidth=" + kernelWidth);
        }
    }

    private class AnimationProcessor
            extends MehrotraAndZhangProcessor {
        public AnimationProcessor() {
            super(kernelWidth, h);
        }

        public ImageProcessorInterface getProcessor(int i) {
            return
                    new MehrotraAndZhangProcessor(
                            kernelWidth,
                            Math.log(i / (float) kernelWidth));
        }
    }


}
