package j2d.edge;

import j2d.ImageUtils;
import ip.transforms.Kernels;
import j2d.ImageProcessorInterface;
import j2d.ImageProcessorFactory;
import j2d.hpp.InvertFilter;
import j2d.hpp.ThresholdProcessor;

import java.awt.*;


public class LoGSobelProcessor
        implements ImageProcessorInterface,
        ImageProcessorFactory {

    private int kernelWidth;
    private double sigma;
    private int thresh = 128;
    private boolean isThresh = true;
    private boolean isSobel = true;


    public LoGSobelProcessor(
            int _kernelWidth,
            double _sigma,
            int _thresh,
            boolean _isThresh,
            boolean _isSobel) {

        kernelWidth = _kernelWidth;
        sigma = _sigma;
        thresh = _thresh;
        isThresh = _isThresh;
        isSobel = _isSobel;
    }

    public ImageProcessorInterface getProcessor(int i) {
        return
                new LoGSobelProcessor(
                        kernelWidth,
                        i + 1,
                        thresh,
                        isThresh, isSobel);
    }

    public Image process(Image img) {
        return LoGSobel(img);

    }

    private Image LoGSobel(Image img) {
        System.out.println(
                "kw=" + kernelWidth +
                " sigma=" + sigma);
        ThresholdProcessor tp = new ThresholdProcessor(thresh);
        ImageProcessorInterface invert = InvertFilter.getProcessor();
        Image logImage = ImageUtils.convolution(img,
                Kernels.getLaplaceOfGaussianKernel(
                        kernelWidth,
                        kernelWidth,
                        sigma));
        if (isThresh) logImage = tp.process(logImage);
        return
                invert.process(sobelImage(logImage));
    }

    private Image sobelImage(Image logImage) {
        if (isSobel)
            return ImageUtils.convolution(logImage,
                    Kernels.getSobel());
        return logImage;
    }

}

