package j2d.edge;

import j2d.ImageProcessorInterface;
import j2d.ImageProcessorFactory;

import java.awt.*;


public class HoughCircles
        implements ImageProcessorInterface,
        ImageProcessorFactory {
    public float radius; // Radius of circles to be found
    public int maxCircles; // Numbers of circles to be found
    public int threshold = -1; // An alternative to maxCircles
    // must lies in the interval: [-125,+125].
    // Higher values - fewer circles.
    byte imageValues[]; // Raw image (returned by ip.getPixels())
    double houghValues[][]; // Hough Space Values
    public int width; // Hough Space width
    public int height;  // Hough Space heigh
    public int offset; // Image Width
    public int offx = 0;   // ROI x offset
    public int offy = 0;   // ROI y offset
    Point centerPoint[]; // Center Points of the Circles Found.
    private int vectorMaxSize = 500;
    boolean useThreshold = false;


    public HoughCircles() {

    }

    public ImageProcessorInterface getProcessor(int a) {
        return new HoughCircles();
    }

    public Image process(Image img) {
        return hough(img);

    }

    private Image hough(Image img) {

        int i = 0;
        int j = 1;
        int k = width - j;
        int l = height - j;
        houghValues = new double[width][height];
        int i2 = Math.round(8F * radius);
        int ai[][] = new int[2][i2];
        for (int j2 = 0; j2 < i2; j2++) {
            double d1 = (6.2831853071795862D * (double) j2) / (double) i2;
            int k1 = (int) Math.round((double) radius * Math.cos(d1));
            int l1 = (int) Math.round((double) radius * Math.sin(d1));
            if ((i == 0) | (k1 != ai[0][i]) & (l1 != ai[1][i])) {
                ai[0][i] = k1;
                ai[1][i] = l1;
                i++;
            }
        }

        double d;

        for (int y = j; y < l; y++) {
            for (int x = j; x < k; x++) {
                if (imageValues[(x + offx) + (y + offy) * offset] == 0)
                    d = 0;
                else
                    d = 1;
                if (d != 0.0D) {
                    for (int i3 = 0; i3 < i; i3++) {
                        int i1 = y + ai[0][i3];
                        int j1 = x + ai[1][i3];
                        if ((i1 >= 0) & (i1 < height) & (j1 >= 0) & (j1 < width)) {
                            houghValues[j1][i1] += d;
                        }
                    }

                }
            }

        }


        return
                null;
    }

}

