package j2d.animation;

import futils.Futil;
import ip.gif.stills.GifDecoder;
import ip.gif.gifAnimation.Gif89Encoder;
import j2d.ImageProcessorFactory;
import j2d.ImageProcessorInterface;
import j2d.ImageUtils;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.*;

/**
 * Created by User: lyon Date: May 4, 2003 Time:
 * 11:35:37 AM
 */
public class GifUtils {
    /**
     * Save still_images to a gif animation file.
     * Annotation is used for the sequence. If
     * looped is true, the animation repeats.
     *
     * @param still_images      images to be written
     * @param annotation        text to be embedded
     *                          into the gif animation
     * @param looped            true means looped
     *                          on playback
     * @param frames_per_second an int
     * @param os                OutputStream to
     *                          send animation
     *                          to.
     * @throws IOException If you run out of disk
     *                     space
     */
    public static void writeGif(
            Image[] still_images,
            String annotation,
            boolean looped,
            double frames_per_second,
            OutputStream os) throws IOException {
        Gif89Encoder ge = new Gif89Encoder();
        for (int i = 0; i < still_images.length; ++i)
            ge.addFrame(still_images[i]);
        ge.setComments(annotation);
        ge.setLoopCount(looped ?
                        0 :
                        1);
        ge.setUniformDelay(
                (int) Math.round(
                        100 / frames_per_second));
        ge.encode(os);
    }

    /**
     * Save imgs into a directory, one image per
     * file. Using GIF format
     *
     * @param imgs a sequence of images to be
     *             written
     */
    public static void writeGifStills(
            Image imgs[]) {
        writeGifStills(imgs,
                       Futil.getReadDirFile(
                               "select gif output dir"));
    }

    /**
     * Save imgs array into a directory, fn, using
     * GIF form, one image per file.
     *
     * @param imgs     array of images to be
     *                 saved
     * @param fileName to be used as the root for
     *                 the output files
     */
    public static void writeGifStills(
            Image imgs[], File fileName) {
        for (int i = 0; i < imgs.length; i++) {
            writeGif(imgs[i],
                     fileName.toString() + i +
                     ".gif");
        }

    }

    /**
     * Saves a 256 color image to a file.
     *
     * @param img An image to be saved
     * @param fn  a string containing the file
     */
    public static void writeGif(Image img,
                                String fn) {
        try {
            ip.vs.WriteGIF.DoIt(img,
                                fn);
        } catch (IOException e) {

        } catch (AWTException e) {

        }
    }

    /**
     * save <code>imgs</code> out to a gif
     * animation file
     *
     * @param imgs  array of 256 color images
     * @param speed speed, in fps, to display gif
     *              animation
     */
    public static void writeGif(Image imgs[],
                                int speed) {
        try {
            FileOutputStream fos =
                    Futil.getFileOutputStream(
                            "output gif animation");
            writeGif(imgs,
                     "A gif animation",
                     true,
                     speed,
                     fos);
            fos.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * Create a gif animation from an
     * <code>ImageProcessorFactory</code>
     *
     * @param sourceImage    the input image
     * @param ipf            the image processor
     *                       factory instance
     * @param numberOfImages
     * @param speed
     */
    public static void writeGifs(
            Image sourceImage,
            ImageProcessorFactory ipf,
            int numberOfImages,
            int speed) {
        try {
            FileOutputStream fos =
                    Futil.getFileOutputStream(
                            "output gif animation");
            Gif89Encoder ge = new Gif89Encoder();
            for (int i = 1; i < numberOfImages; i++) {
                ImageProcessorInterface ip = ipf.getProcessor(
                        i);
                try {
                    Image img = ip.process(
                            sourceImage);
                    ge.addFrame(img);
                } catch (Exception e) {
                    System.out.println(
                            "error on image:" +
                            i);
                    continue;
                }

                ge.setUniformDelay(
                        Math.round(100 / speed));
                System.out.println(
                        "processed frame:" + i);
            }
            System.out.println("done!");

            ge.setLoopCount(true ?
                            0 :
                            1);

            ge.encode(fos);
            fos.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Get a gif animation as an array of image.
     *
     * @return the image array
     */
    public static Image[] getGifs() {
        GifDecoder gd = new GifDecoder();
        FileInputStream fis =
                Futil.getFileInputStream(
                        "select a gif animation file");
        BufferedInputStream bis =
                new BufferedInputStream(fis);

        gd.read(bis);
        int nof = gd.getFrameCount();
        Image[] ia = new Image[nof];
        for (int i = 0; i < nof; i++) {
            BufferedImage bi = gd.getFrame(i);
            ia[i] = ImageUtils.getImage(bi);
            System.out.println("got image#" + i);
        }
        Futil.close(fis);
        return ia;
    }
}
