/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Apr 26, 2003
 * Time: 7:25:34 AM
 */
package j2d.animation;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.ImageProcessorFactory;

import javax.swing.*;
import java.awt.*;


public class AnimationDialog {
    private ImageProcessorFactory ipf;
    private Image orgImg;
    private int numberOfFrames = 10;
    private int fps = 10;


    JDialog jd = new JDialog(new JFrame(),
            "A dialog", true);

    public AnimationDialog(Image orgImg,
                           ImageProcessorFactory ipf) {
        this.ipf = ipf;
        this.orgImg = orgImg;
        getDialog();
    }


    public void getDialog() {

        Container c = jd.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());

        jp.add(getFpsPanel());
        jp.add(getNumberOfFramesPanel());
        jp.add(getOkCancelPanel());

        c.add(jp);
        jd.setSize(200, 200);
        jd.show();

    }

    private void cancel() {
        jd.dispose();
    }

    private JPanel getOkCancelPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("ok") {
            public void run() {
                GifUtils.writeGifs(
                        orgImg,
                        ipf, numberOfFrames, fps);
            }
        });
        jp.add(new RunButton("cancel") {
            public void run() {
                cancel();
            }
        });
        return jp;
    }

    private JPanel getNumberOfFramesPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        JLabel jl = new JLabel("number of Frames");
        jp.add(jl, BorderLayout.NORTH);

        jp.add(new RunSlider(1, 300, 10) {
            public void run() {
                numberOfFrames = getValue();
            }
        }, BorderLayout.CENTER);
        return jp;
    }

    private JPanel getFpsPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(new RunSlider(1, 30, 10) {
            public void run() {
                fps = getValue();
            }
        }, BorderLayout.CENTER);
        jp.add(new JLabel("fps"), BorderLayout.NORTH);
        return jp;
    }

}
