package j2d;

import ip.transforms.Kernels;
import math.Mat1;

import java.awt.*;
import java.util.Vector;

/**
 * GPL code by DocJava, Inc.
 * User: lyon
 * Date: Mar 5, 2003
 * Time: 5:44:03 PM
 *
 */
public class ShortImageBeans {
    private Vector v = new Vector();

    public void add(ShortImageBean sib) {
        v.addElement(sib);
    }

    public ShortImageBean[] getShortImageBeans() {
        ShortImageBean sba[] = new ShortImageBean[v.size()];
        v.copyInto(sba);
        return sba;
    }


    public static ShortImageBeans computeComparisons(Image sourceImage,
                                                     ImageProcessorFactory ipf,
                                                     int numberOfImages) {
        ShortImageBeans sibs = new ShortImageBeans();

        for (int i = 1; i < numberOfImages; i++) {
            ImageProcessorInterface ip = ipf.getProcessor(i);
            sibs.add(new ShortImageBean(
                    ip.process(sourceImage)));
        }
        return sibs;
    }

    public ShortImageBeans getImageFlows() {
        ShortImageBeans imageFlows = new ShortImageBeans();
        int numberOfImages = v.size();
        ShortImageBean sbi[] = getShortImageBeans();
        for (int i = 1; i < numberOfImages; i++)
            imageFlows.add(sbi[i].getImageFlowBean());
        return imageFlows;
    }

    public static void print(double s[]) {
        System.out.println("histogram of scales:");
        for (int i = 0; i < s.length; i++)
            System.out.println(s[i]);
    }

    private byte sigma[][] = null;

    private double subBandHistogram[] = null;

    public ShortImageBean getMaxBean() {
        ShortImageBean sib[] = getShortImageBeans();
        int w = sib[0].getWidth();
        int h = sib[0].getHeight();
        ShortImageBean maxBean = new ShortImageBean(w, h);
        short r[][] = maxBean.getR();
        short g[][] = maxBean.getG();
        short b[][] = maxBean.getB();

        sigma = new byte[w][h];
        subBandHistogram = new double[v.size()];
        computeSigmaMaxForEachPixel(w, h, maxBean, sib, r, g, b);
        printTheSubbandHistogramSigmaMinus1();
        return maxBean;
    }

    public double[][] getOrientation() {
        ShortImageBean sib = getMaxBean();
        short r[][] = sib.getR();
        double o[][] = new double[r.length][r[0].length];
        float ns[][] = Kernels.getRobinson1();
        float ew[][] = Kernels.getRobinson3();
        Image maxImage = sib.getImage();
        ShortImageBean nsb =
                new ShortImageBean(
                        ImageUtils.convolution(maxImage, ns));
        ShortImageBean ewb =
                new ShortImageBean(
                        ImageUtils.convolution(maxImage, ew));
        short imaginaryPart[][] = nsb.getR();
        short realPart[][] = ewb.getR();
        for (int x = 0; x < o.length; x++)
            for (int y = 0; y < o.length; y++) {
                double dy = imaginaryPart[x][y];
                double dx = realPart[x][y];
                o[x][y] = Math.atan2(dy, dx);
            }
        return o;

    }

    public void add(ShortImageBeans sibs) {
        ShortImageBean sib[] = getShortImageBeans();
        for (int i = 0; i < sib.length; i++)
            add(sib[i]);
    }

    public ShortImageBeans getOrientationSubBands() {
        ShortImageBeans orientation = new ShortImageBeans();
        ShortImageBean sib[] = getShortImageBeans();
        float ns[][] = Kernels.getRobinson1();
        float ew[][] = Kernels.getRobinson3();
        for (int i = 0; i < sib.length; i++) {
            ShortImageBean nsb =
                    new ShortImageBean(
                            ImageUtils.convolution(sib[i].getImage(), ns));
            ShortImageBean ewb =
                    new ShortImageBean(
                            ImageUtils.convolution(sib[i].getImage(), ew));
            orientation.add(nsb);
            orientation.add(ewb);
        }
        return orientation;
    }

    private void printTheSubbandHistogramSigmaMinus1() {
        Mat1.normalize(subBandHistogram);
        print(subBandHistogram);
    }

    private void computeSigmaMaxForEachPixel(int w, int h, ShortImageBean maxBean, ShortImageBean[] sib, short[][] r, short[][] g, short[][] b) {
        for (int x = 0; x < w; x++) {
            for (int y = 0; y < h; y++) {
                int subBand =
                        selectSubBand(maxBean, x, y, sib, r, g, b);
                sigma[x][y] = (byte) (subBand + 1);

            }
        }
    }

    private int selectSubBand(ShortImageBean maxBean,
                              int x, int y,
                              ShortImageBean sib[],
                              short r[][],
                              short g[][],
                              short b[][]) {
        int a = maxBean.getAverage(x, y);
        int subBand = 0;
        for (int i = 0; i < sib.length; i++) {
            if (a < sib[i].getAverage(x, y)) {
                r[x][y] = sib[i].getR()[x][y];
                g[x][y] = sib[i].getG()[x][y];
                b[x][y] = sib[i].getB()[x][y];
                a = maxBean.getAverage(x, y);
                subBand = i;
                subBandHistogram[i]++;
            }
        }
        return subBand;
    }

    public ShortImageBeans() {
    }

}
