/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 3, 2003
 * Time: 6:17:06 PM
 */
package j2d;

import j2d.animation.AnimationPanel;
import j2d.color.ColorSpacePanel;
import j2d.color.ColorizerPanel;
import j2d.edge.*;
import j2d.hpp.*;
import j2d.filters.GaussianPanel;

import javax.swing.*;
import java.awt.*;

import utils.StringUtils;

public class ImageTabbedPane extends JTabbedPane {
    ImageProcessListener ipl = null;

    public static void addTab(JTabbedPane jtp,
                              String title,
                              Icon icon, Component component) {
        int i1 = title.indexOf('[');
        if (i1 == -1) {
            (jtp).addTab(title, icon, component);
            return;
        }

        String newTitle = StringUtils.replaceFirstInstance(
                title, "[", "");
        addTab(jtp, newTitle, icon, component);
        int location = jtp.getTabCount();
        jtp.setMnemonicAt(location, title.charAt(i1 + 1));
    }


    public JFrame getFrame() {
        Container c = this.getParent();
        while (c != null && !(c instanceof JFrame)) {
            c = this.getParent();
        }
        if (c == null) return null;
        return (JFrame) c;
    }

    public ImageTabbedPane(ImageProcessListener _ipl) {
        ipl = _ipl;

        addTab(this, "FilePanel", null,
                new FilePanel(ipl));
        addTab(this, "Animation", null,
                new AnimationPanel(ipl));

        addTab(this, "Gaussian", null,
                new GaussianPanel(ipl));
        addTab(this, "Hpp", null,
                getHppPane());
        addTab(this, "Edge", null,
                getEdgePane());
    }


    public JTabbedPane getEdgePane() {
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("MagDOG", null,
                new MagDOGPanel(ipl));
        jtp.addTab("SobelPanel", null,
                new SobelPanel(ipl));
        jtp.addTab("LoGSobelPanel", null,
                new LoGSobelPanel(ipl));
        jtp.addTab("LoGPanel", null,
                new LoGPanel(ipl));
        jtp.addTab("MehrotraAndZhangPanel", null,
                new MehrotraAndZhangPanel(ipl));

        jtp.addTab("Canny", null,
                new CannyPanel(ipl));
        jtp.addTab("Threshold", null,
                new ThresholdPanel(ipl));
        jtp.addTab("TemplatePanel", null,
                new TemplatePanel(ipl));
        return jtp;
    }

    public JTabbedPane getHppPane() {
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab("ColorizerPanel", null,
                new ColorizerPanel(ipl));
        jtp.addTab("ColorSpacePanel", null,
                new ColorSpacePanel(ipl));
        jtp.addTab("ContrastPanel", null,
                new ContrastPanel(ipl));
        jtp.addTab("GreyHppFilter3Panel", null,
                new GreyHppFilter3Panel(ipl));
        jtp.addTab("ThresholdFilter3Panel", null,
                new ThresholdFilter3Panel(ipl));
        jtp.addTab("HistogramPanel", null,
                new HistogramPanel(ipl));

        return jtp;
    }
}
