package ip.hak;

import java.awt.*;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;


public class Point4 extends Component {
    Point center;
    Image image, selectedImage, unselectedImage;
    Dimension imageDim;
    boolean inv;

    public Point4(Point cen) {
        center = cen;
        unselectedImage = byte2Image(unselected);
        selectedImage = byte2Image(selected);
        image = unselectedImage;
        imageDim = new Dimension(unselected.length, unselected[0].length);
        inv = false;
    }

    public void setCenter(Point p) {
        center = p;
    }

    public Point getCenter() {
        return center;
    }

    public boolean contain(Point p) {
        int hx = imageDim.width / 2;
        int hy = imageDim.height / 2;
        int minx = center.x - hx;
        int maxx = center.x + hx;
        int miny = center.y - hy;
        int maxy = center.y + hy;

        System.out.println("X=" + p.x + " max=" + maxx + " min=" + minx);
        System.out.println("Y=" + p.y + " max=" + maxy + " min=" + miny);
        return (p.x >= minx && p.x <= maxx && p.y >= miny && p.y <= maxy && image != null);
    }

    public boolean contains(int x, int y) {

        return (x >= 0 && x < imageDim.width && y >= 0 && y < imageDim.height && image != null);
    }

    public void reshape(Point cp, Dimension dim) {
        setBounds(
                cp.x - dim.width / 2,
                cp.y - dim.height / 2,
                dim.width,
                dim.height);
    }

    public void reshape() {
        setBounds(
                center.x - imageDim.width / 2,
                center.y - imageDim.height / 2,
                imageDim.width, imageDim.height);
    }

    public Dimension getPreferredSize() {
        return imageDim;
    }

    public void update(Graphics g) {
        paint(g);
    }

    public void paint(Graphics g) {
        if (image != null) {
            //int xg=imageDim.width/2;
            //int yg=imageDim.height/2;
            //g.drawImage(image,center.x-xg,center.y-yg,imageDim.width, imageDim.height,this);
            g.drawImage(image, 0, 0, imageDim.width, imageDim.height, this);
            //g.drawString("X : "+center.x+" Y : "+center.y,center.x+10,center.y);
        }
    }

    private static Image byte2Image(byte r[][]) {
        int w = r.length;
        int h = r[0].length;
        int v = 0;
        Toolkit tk = Toolkit.getDefaultToolkit();
        int pels[] = new int[w * h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                if (r[x][y] == 1)
                    v = 255;
                else
                    v = 0;
                pels[y + x * h] = 0xff000000 | (v << 16) | (v << 8) | v;
            }
        Image i = tk.createImage(new MemoryImageSource(w, h, ColorModel.getRGBdefault(), pels, 0, w));
        return i;
    }

    public void invert() {
        if (!inv)
            image = selectedImage;
        else
            image = unselectedImage;
        inv = !inv;
        repaint();
    }

    private static byte selected[][] = {
        {1, 1, 1, 0, 0, 0, 0, 1, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 0, 0, 0, 0, 0, 0, 0, 0, 1},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {1, 0, 0, 0, 0, 0, 0, 0, 0, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 1, 1, 0, 0, 1, 1, 1, 1}};


    private static byte unselected[][] = {
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
        {1, 1, 1, 0, 0, 0, 0, 1, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
        {1, 1, 1, 0, 0, 0, 0, 1, 1, 1},
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};


}