package ip.hak;

import java.awt.*;

public class ImageComponent extends Component {

    MyPanel mp;
    Image im[],buffer;
    Graphics gContext;
    int total,current;
    boolean mo = false;


    public ImageComponent() {
    }

    public ImageComponent(int w, int h, MyPanel myp) {
        mp = myp;
        setSize(w, h);
    }

    public ImageComponent(int w, int h, MyPanel myp, int id) {
        mp = myp;
        setSize(w, h);
    }

    public void switchMessage() {
        mo = !mo;
        repaint();
    }

    public void showImage(Image ia[], Dimension di) {
        im = ia;
        total = im.length;
        buffer = createImage(di.width, di.height);
        gContext = buffer.getGraphics();
        Dimension d = getSize();
        gContext.drawImage(im[0], 0, 0, d.width, d.height, this);
        current = 1;
    }

    public void paint(Graphics g) {

        super.paint(g);
        Dimension d = getSize();
        setForeground(Color.black);

        if (im == null) {

            g.drawRect(1, 1, d.width - 2, d.height - 2);
            if (mo)
                g.drawString("Wait...", d.width / 2 - 10, d.height / 2 - 5);
            return;
        }

        g.drawImage(buffer, 0, 0, d.width, d.height, this);



        // draw new image in buffer
        gContext.drawImage(im[current], 0, 0, d.width, d.height, this);

        // loop
        current = (current + 1) % total;

        try {
            Thread.sleep(100);
        } catch (InterruptedException e) {
            System.out.println(e);
        }

        repaint(); // display buffer image
    }

}