package ip.gui.frames;

import gui.Clipper;
import ip.gui.dialog.AdaptiveLog;
import ip.gui.dialog.ExponentialLog;
import ip.gui.dialog.GrayLog;
import ip.gui.dialog.RayleighLog;
import ip.transforms.TransformTable;
import j2d.ShortImageBean;
import math.Mat2;
import utils.Print;

import javax.media.jai.KernelJAI;
import java.awt.*;
import java.awt.event.ActionEvent;

public class NegateFrame extends GrabFrame {
               
    private HistogramFrame rh,gh,bh;
    KernelJAI kj = KernelJAI.GRADIENT_MASK_SOBEL_HORIZONTAL;

    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    // used for adaptive image enhancement
    private int mosaicWidth = 2;
    private int mosaicHeight = 2;

    private double rBar = 0;
    private double gBar = 0;
    private double bBar = 0;

    private TransformTable tt =
            new TransformTable(256);

    private Menu negateMenu = getMenu("Negate");
    private Menu histogramMenu = getMenu("Histogram");

    private MenuItem negate_mi =
            addMenuItem(negateMenu, "[E-n]egate");
    private MenuItem add10_mi =
            addMenuItem(negateMenu, "[E-1]add 10");
    private MenuItem brighten_mi =
            addMenuItem(negateMenu, "[E-b]righten");
    private MenuItem darken_mi =
            addMenuItem(negateMenu, "[E-d]arken");
    private MenuItem linear_mi =
            addMenuItem(negateMenu, "[E-l]inear transform...");

    private MenuItem histogram_mi =
            addMenuItem(histogramMenu, "[E-h]istogram");
    private MenuItem unahe_mi =
            addMenuItem(histogramMenu,
                    "[E-u]niform non-adaptive histogram equalization");
    private MenuItem enahe_mi =
            addMenuItem(histogramMenu, "[E-e]xponential non-adaptive histogram equalization...");
    private MenuItem rnahe_mi =
            addMenuItem(histogramMenu,
                    "[E-r]ayleigh non-adaptive histogram equalization...");

    private MenuItem auhe_mi =
            addMenuItem(histogramMenu, "[E-a]uhe adaptive uniform histogram equalization");
    private MenuItem drawMosaic_mi =
            addMenuItem(histogramMenu, "[E-d]raw Mosaic");
    private MenuItem printTT_mi =
            addMenuItem(histogramMenu, "[E-T-t]print transform table...");
    private MenuItem printStats_mi =
            addMenuItem(histogramMenu, "[E-T-p]rintStats");
    private MenuItem printPMFs_mi =
            addMenuItem(histogramMenu, "[E-1]printPMFs");
    private MenuItem printCMFs_mi =
            addMenuItem(histogramMenu, "[E-2]printCMF for r");


    public void actionPerformed(ActionEvent e) {

        if (match(e, drawMosaic_mi)) {
            drawMosaic();
            return;
        }
        if (match(e, rnahe_mi)) {
            rayleighLog();
            return;
        }
        if (match(e, auhe_mi)) {
            auhe();
            return;
        }
        if (match(e, enahe_mi)) {
            eponentialLog();
            return;
        }
        if (match(e, printCMFs_mi)) {
            printCMFs();
            return;
        }
        if (match(e, printPMFs_mi)) {
            printPMFs();
            return;
        }
        if (match(e, printStats_mi)) {
            printStats();
            return;
        }
        if (match(e, unahe_mi)) {
            unahe();
            return;
        }
        if (match(e, printTT_mi)) {
            printTT();
            return;
        }
        if (match(e, linear_mi)) {
            linearLog();
            return;
        }
        if (match(e, darken_mi)) {
            darken();
            return;
        }
        if (match(e, brighten_mi)) {
            brighten();
            return;
        }
        if (match(e, histogram_mi)) {
            histogram();
            return;
        }
        if (match(e, add10_mi)) {
            add10();
            return;
        }
        if (match(e, negate_mi)) {
            negate();
            return;
        }
        super.actionPerformed(e);

    }

    /**
     mosaic - transform an array of
     short into sub-images
     */
    public void auhe() {
        auhe(mosaicWidth, mosaicHeight);
    }

    public void drawMosaic() {
        AdaptiveLog.doit(this);
    }

    /**
     mosaic - transform an array of
     short into sub-images
     ignoring fractional parts.
     */
    public void auhe(int blocksHigh, int blocksWide) {

        int pelsWide = getImageWidth() / blocksWide;
        int pelsHigh = getImageHeight() / blocksHigh;
        int newWidth = pelsWide * blocksWide;
        int newHeight = pelsHigh * blocksHigh;
        NegateFrame nf;

        for (int x1 = 0; x1 < newWidth; x1 += pelsWide)
            for (int y1 = 0; y1 < newHeight; y1 += pelsHigh) {
                nf = subFrame(x1, y1, pelsWide, pelsHigh);
                nf.unahe();
                assembleMosaic(nf, x1, y1);
            }
        short2Image();
    }

    public void assembleMosaic(NegateFrame nf, int x1, int y1) {
        int x2 = getImageWidth() + x1;
        int y2 = getImageHeight() + y1;
        int xs = 0;
        int ys = 0;
        for (int x = x1; x < x2; x++) {
            for (int y = y1; y < y2; y++) {
                shortImageBean.getR()[x][y] = shortImageBean.getR()[xs][ys];
                shortImageBean.getG()[x][y] = shortImageBean.getG()[xs][ys];
                shortImageBean.getB()[x][y] = shortImageBean.getB()[xs][ys];
                ys++;
            }
            ys = 0;
            xs++;
        }
    }

    public void drawMosaic(int blocksHigh, int blocksWide) {
        mosaicWidth = blocksWide;
        mosaicHeight = blocksHigh;

        int pelsWide = getImageWidth() / blocksWide;
        int pelsHigh = getImageHeight() / blocksHigh;
        int newWidth = pelsWide * blocksWide;
        int newHeight = pelsHigh * blocksHigh;

        int x1 = 0, y1 = 0;
        Print.println("DrawMosaic" +
                " newWidth=" + newWidth +
                " newHeight=" + newHeight +
                " pelsWide=" + pelsWide +
                " pelsHigh=" + pelsHigh);
        Graphics gx = getGraphics();
        for (x1 = 0; x1 < newWidth; x1 += pelsWide)
            for (y1 = 0; y1 < newHeight; y1 += pelsHigh) {
                gx.drawRect(x1, y1, pelsWide, pelsHigh);
            }
    }

    public NegateFrame subFrame(int x1, int y1, int w, int h) {
        short _r[][] = new short[w][h];
        short _g[][] = new short[w][h];
        short _b[][] = new short[w][h];
        int x2 = x1 + w;
        int y2 = y1 + h;
        // for loop computes source coordinates
        int xd = 0;
        int yd = 0;

        Print.println("Subframe" +
                " x1=" + x1 +
                " y1=" + y1 +
                " x2=" + x2 +
                " y2=" + y2);
        for (int x = x1; x < x2; x++) {
            for (int y = y1; y < y2; y++) {
                _r[xd][yd] = shortImageBean.getR()[x][y];
                _g[xd][yd] = shortImageBean.getG()[x][y];
                _b[xd][yd] = shortImageBean.getB()[x][y];
                yd++;
            }
            yd = 0;
            xd++;
        }
        return new
                NegateFrame(_r, _g, _b, "frame");
    }

    private void doMenus() {
        negateMenu.add(histogramMenu);
        filterMenu.add(negateMenu);
    }

    public NegateFrame(
            short _r[][], short _g[][], short _b[][],
            String title) {
        super(title);
        doMenus();
        System.out.println("New constructor invoked");
        shortImageBean.setR(_r);
        setB(_b);
        setG(_g);
        // show image ...very slow
        // but interesting!
        short2Image();
    }

    public void printTT() {
        tt.print();
    }

    public void add10() {
        shortImageBean.add(10);
        short2Image();
    }

    public void histogram() {
        rh = new HistogramFrame(shortImageBean.getR(), "Red");
        gh = new HistogramFrame(shortImageBean.getG(), "Green");
        bh = new HistogramFrame(shortImageBean.getB(), "Blue");
        rh.myShow();
        gh.myShow();
        bh.myShow();
    }

    public void negate() {
        shortImageBean.negate();
        short2Image();
    }

    private void brighten() {
        powImage(this, shortImageBean, 0.9);
    }

    private void darken() {
        powImage(this, shortImageBean, 1.5);
    }

    public static void powImage(ImageFrameInterface ifi, ShortImageBean nf, double p) {
        for (int x = 0; x < nf.getWidth(); x++)
            for (int y = 0; y < nf.getHeight(); y++) {
                nf.getR()[x][y] = (short)
                        (255 * Math.pow((nf.getR()[x][y] / 255.0), p));
                nf.getG()[x][y] = (short)
                        (255 * Math.pow((nf.getG()[x][y] / 255.0), p));
                nf.getB()[x][y] = (short)
                        (255 * Math.pow((nf.getB()[x][y] / 255.0), p));
            }
        ifi.short2Image();
    }

    // Uniform Non Adaptive Histogram
    // Equalization
    public void unahe() {
        short lut[] = tt.getLut();
        double h[] = getAverageCMF();
        for (short i = 0; i < lut.length; i++)
            lut[i] = (short) (255 * h[i]);
        applyLut(lut);
    }

    // Rayleigh Non Adaptive Histogram
    // Equalization
    public void rnahe(double alpha) {
        short lut[] = tt.getLut();
        double h[] = getAverageCMF();
        double alpha2 = 2 * alpha * alpha;
        double v;
        double g;
        for (short i = 0; i < h.length; i++) {
            g = alpha2 * Math.log(1 / (1.0 - h[i]));
            v = Math.sqrt(g);
            lut[i] = (short) (255 * v);
        }
        tt.clip();
        applyLut(lut);
    }

    // Exponential Non Adaptive Histogram
    // Equalization
    public void enahe(double alpha) {
        short lut[] = tt.getLut();
        double h[] = getAverageCMF();
        for (short i = 0; i < 256; i++)
            lut[i] = (short)
                    (255 * (-Math.log(1.0 - h[i]) / alpha));
        tt.clip();
        applyLut(lut);
    }


    public double[] getAverageCMF() {
        rh = new HistogramFrame(shortImageBean.getR(), "Red");
        gh = new HistogramFrame(shortImageBean.getG(), "Green");
        bh = new HistogramFrame(shortImageBean.getB(), "Blue");
        double CMFr[] = rh.getCMF();
        double CMFg[] = gh.getCMF();
        double CMFb[] = bh.getCMF();
        return Mat2.getAverage(CMFr, CMFg, CMFb);
    }

    public void applyLut(short lut[]) {
        wellConditioned(); //Shorts could be out of range;
        for (int x = 0; x < getImageWidth(); x++)
            for (int y = 0; y < getImageHeight(); y++) {

                shortImageBean.getR()[x][y] = lut[shortImageBean.getR()[x][y]];
                shortImageBean.getG()[x][y] = lut[shortImageBean.getG()[x][y]];
                shortImageBean.getB()[x][y] = lut[shortImageBean.getB()[x][y]];
            }
        short2Image();
    }

    public void applyLut(short lutr[], short lutg[], short lutb[]) {
        wellConditioned(); //Shorts could be out of range;
        for (int x = 0; x < getImageWidth(); x++)
            for (int y = 0; y < getImageHeight(); y++) {

                shortImageBean.getR()[x][y] = lutr[shortImageBean.getR()[x][y]];
                shortImageBean.getG()[x][y] = lutg[shortImageBean.getG()[x][y]];
                shortImageBean.getB()[x][y] = lutb[shortImageBean.getB()[x][y]];
            }
        short2Image();
    }

    public void wellConditioned() {
        for (int x = 0; x < getImageWidth(); x++)
            for (int y = 0; y < getImageHeight(); y++) {
                shortImageBean.getR()[x][y] = inRange(shortImageBean.getR()[x][y], x, y);
                shortImageBean.getG()[x][y] = inRange(shortImageBean.getG()[x][y], x, y);
                shortImageBean.getB()[x][y] = inRange(shortImageBean.getB()[x][y], x, y);
            }
    }

    public short inRange(short v, int x, int y) {
        if (v > 255) {
            Print.println(
                    "out of range x=" + x + " y=" + y +
                    "v=" + v + " clipping to 255");
            return 255;
        }
        if (v < 0) {
            Print.println(
                    "out of range x=" + x + " y=" + y +
                    "v=" + v + " clipping to 0");
            return 0;
        }
        return v;
    }

    public short linearMap(short v,
                           double c, double b) {
        // scale gray value to 0..1 range
        double f = c * v + b;
        // scale f into 0..255 range
        // clip f into range
        if (f > 255) f = 255;
        if (f < 0) f = 0;
        return (short) f;
    }

    public void linearTransform() {
        computeStats();
        int Vmin = getMinimum();
        int Vmax = getMaximum();
        int Dmin = 0;
        int Dmax = 255;
        double deltaV = Vmax - Vmin;
        double deltaD = Dmax - Dmin;
        double c = deltaD / deltaV;
        double b = (Dmin * Vmax - Dmax * Vmin) / deltaV;
        linearTransform(c, b);
    }

    public void linearTransform(double c, double br) {
        linearTransform(c, br, shortImageBean);
        Clipper clipper = getClipper();
        clipper.clip(shortImageBean);
        short2Image();
    }

    public static void linearTransform(double c, double br, ShortImageBean b) {
        int w = b.getWidth();
        int h = b.getHeight();
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                b.getR()[x][y] = (short) (c * b.getR()[x][y] + br);
                b.getG()[x][y] = (short) (c * b.getG()[x][y] + br);
                b.getB()[x][y] = (short) (c * b.getB()[x][y] + br);
            }

    }

    // The following transform is fast, but
    // only works on well conditioned input.
    // I.e., r,g,b [0..255].
    public void linearTransform2(double c, double br) {

        short lut[] = tt.getLut();
        for (short i = 0; i < 256; i++)
            lut[i] = linearMap(i, c, br);
        for (int x = 0; x < getImageWidth(); x++)
            for (int y = 0; y < getImageHeight(); y++) {
                shortImageBean.getR()[x][y] = lut[shortImageBean.getR()[x][y]];
                shortImageBean.getG()[x][y] = lut[shortImageBean.getG()[x][y]];
                shortImageBean.getB()[x][y] = lut[shortImageBean.getB()[x][y]];
            }
        short2Image();
    }

    public void computeStats() {

        min = Integer.MAX_VALUE;
        max = Integer.MIN_VALUE;
        rBar = 0;
        gBar = 0;
        bBar = 0;
        double N = getImageWidth() * getImageHeight();
        for (int x = 0; x < getImageWidth(); x++)
            for (int y = 0; y < getImageHeight(); y++) {
                rBar += shortImageBean.getR()[x][y];
                gBar += shortImageBean.getG()[x][y];
                bBar += shortImageBean.getB()[x][y];
                min = Math.min(shortImageBean.getR()[x][y], min);
                min = Math.min(shortImageBean.getG()[x][y], min);
                min = Math.min(shortImageBean.getB()[x][y], min);
                max = Math.max(shortImageBean.getR()[x][y], max);
                max = Math.max(shortImageBean.getG()[x][y], max);
                max = Math.max(shortImageBean.getB()[x][y], max);
            }
        rBar /= N;
        gBar /= N;
        bBar /= N;
    }

    public void printPMFr() {
        rh = new HistogramFrame(shortImageBean.getR(), "Red");
        rh.printPMF();
    }

    public void printCMFs() {
        rh = new HistogramFrame(shortImageBean.getR(), "Red");
        rh.printCMF();
    }

    public void printPMFg() {
        gh = new HistogramFrame(shortImageBean.getG(), "Green");
        gh.printPMF();

    }

    public void printPMFb() {
        bh = new HistogramFrame(shortImageBean.getB(), "Blue");
        bh.printPMF();

    }

    public void printPMFs() {
        printPMFr();
        printPMFg();
        printPMFb();
    }

    public void printStats() {
        computeStats();
        Print.println(
                "Min Vij=" + getMinimum() + "\n" +
                "Max Vij=" + getMaximum() + "\n" +
                "rBar = " + getRBar() + "\n" +
                "gBar = " + getGBar() + "\n" +
                "bBar = " + getBBar()
        );

    }

    public double getRBar() {
        return rBar;
    }

    public double getGBar() {
        return gBar;
    }

    public double getBBar() {
        return bBar;
    }

    public int getMinimum() {
        return min;
    }

    public int getMaximum() {
        return max;
    }

    public void eponentialLog() {
        String prompts[] = {
            "alpha = "
        };
        String defaults[] = {
            "4.0"};
        String title = "Exponential Transform Dialog";


        new ExponentialLog(
                this,
                title,
                prompts,
                defaults, 9);
    }

    public void rayleighLog() {
        String prompts[] = {
            "alpha = "
        };
        String defaults[] = {
            "4.0"};
        String title = "Rayleigh Transform Dialog";


        new RayleighLog(
                this,
                title,
                prompts,
                defaults, 9);
    }

    public void linearLog() {
        String prompts[] = {
            "Contrast = c =",
            "Brightness = b ="
        };
        computeStats();
        int Vmin = getMinimum();
        int Vmax = getMaximum();
        int Dmin = 0;
        int Dmax = 255;
        double deltaV = Vmax - Vmin;
        double deltaD = Dmax - Dmin;
        double c = deltaD / deltaV;
        double b = (Dmin * Vmax - Dmax * Vmin) / deltaV;
        Print.println("C=" + c + " b=" + b);

        String defaults[] = {
            Double.toString(c),
            Double.toString(b)};
        String title = "Linear Grayscale Transform Dialog";


        new GrayLog(
                this,
                title,
                prompts,
                defaults, 9);

    }

    public NegateFrame(String title) {
        super(title);
        doMenus();
    }

    public static void main(String args[]) {
        new NegateFrame("NegateFrame");
    }
}

