package ip.gui.frames;

import gui.PetriBean;
import gui.JClosableFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

/**
 *
 */

public class JShortCutFrame
        extends JClosableFrame
        implements ShortCutInterface {


    private PetriBean petriBean = new PetriBean(this);


    public JShortCutFrame(String title) {
        super(title);
        addKeyListener(this);
    }

    public JShortCutFrame() {
        addKeyListener(this);
    }

    public String getPs() {
        return petriBean.getPs();
    }


    public boolean match(AWTEvent e, JMenuItem mi) {
        return petriBean.matchEvent(e, mi);
    }

    public boolean match(AWTEvent e, MenuItem mi) {
        return petriBean.matchEvent(e, mi);
    }


    public void keyPressed(KeyEvent e) {
        petriBean.processEvent(e);
    }


    public void keyReleased(KeyEvent e) {
    }


    public void actionPerformed(ActionEvent e) {
    }


    public void keyTyped(KeyEvent e) {
    }

    public Menu getMenu(String s) {
        return new Menu(s);
    }

    public JMenuItem addMenuItem(JMenu aMenu, String itemName) {
        JMenuItem mi = new JMenuItem(itemName);
        aMenu.add(mi);
        mi.addActionListener(this);
        return (mi);
    }

    public MenuItem addMenuItem(Menu aMenu, String itemName) {
        MenuItem mi = new MenuItem(itemName);
        aMenu.add(mi);
        mi.addActionListener(this);
        return (mi);
    }
}
