//--------------------------------
//File: 		DoubleArrayLog.java
//Date: 		03/29/99
//Student id: 	0424811
//Student name: Jitendra Shiralkar
//Compiled on: 	JDK 1.2
//--------------------------------
//
//Class implemented: DoubleArrayLog
//Derived from:      ArrayDialog
//Uses:              MessageLog
//
//Description:
//	The DoubleArrayLog class accepts only double values for the array elements.
//A message Dialog is shown to the user if he/she has made error in input.
//
package ip.gui.dialog;

import ip.gui.frames.ConvolutionFrame;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DoubleArrayLog
        extends ArrayDialog
        implements ActionListener {

    public DoubleArrayLog(ConvolutionFrame frame, String title,
                          String defaults[][], int row, int col, int fieldSize) {
        super(frame, title, defaults, row, col, fieldSize);
        cf = frame;
    }

    ConvolutionFrame cf;

    public void printUserInput() {
        double userInput[][] = getUserInputAsDouble();
        System.out.println("The values set to the array elements are:");
        System.out.println("*****************************************");
        for (int i = 0; i < userInput.length; i++) {
            for (int j = 0; j < userInput[0].length; j++) {
                System.out.print("" + userInput[i][j] + " ");
            }
            System.out.println();
        }
    }

    public void convolve() {
        float userInput[][] = getUserInputAsFloat();
        cf.convolve(userInput);
    }

    public float[][] getUserInputAsFloat() {
        double ud[][] = getUserInputAsDouble();
        int w = ud.length;
        int h = ud[0].length;
        float uf[][] = new float[w][h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++)
                uf[x][y] = (float) ud[x][y];
        return uf;

    }

    public double[][] getUserInputAsDouble() {
        String userInput[][] = super.getUserInput(); //calling the super class method getUserInput()
        double dui[][] = new double[userInput.length][userInput[0].length];
        int i = 0, j = 0;

        try {
            for (i = 0; i < userInput.length; i++) {
                for (j = 0; j < userInput[0].length; j++) {
                    Double d = Double.valueOf(userInput[i][j]);
                    dui[i][j] = d.doubleValue();
                }
            }
        } catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer();
            message.append("Could not convert to double\n");
            message.append("Row: " + (i + 1) + "Column: " + (j + 1) + "\n");
            message.append("Value: " + e.getMessage());
            ;

            MessageLog m1 = new MessageLog("Input Error: Could not convert to Double", message.toString());
        }

        return dui;
    }

    public void actionPerformed(ActionEvent e) {
        Button b = (Button) e.getSource();
        if (b == super.cancelButton) { //if cancel button was pressed, exit
            setVisible(false);
            System.exit(0);
        } else
        //printUserInput();
            convolve();
    }

}

class MessageLog extends Dialog implements ActionListener {
    Button okButton = new Button("OK");
    Panel buttonPanel = new Panel();
    Label messageLabel = new Label();

    public MessageLog(String title, String message) {
        super(new Frame(), title, true);	//sets the MessageLog modal
        okButton.addActionListener(this);
        messageLabel.setText(message);

        setLayout(new GridLayout(0, 1));
        add(messageLabel);
        add(okButton);
        pack();
        show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == okButton)
            setVisible(false);
    }
}
