package ip.color;

import ip.gui.frames.ColorFrame;
import math.Mat3;


public class Yiq extends FloatPlane {

// for ntsc rgb, use
    double A[][] = {
        {0.2989, 0.5866, 0.1144},
        {0.5959, -0.2741, -0.3218},
        {0.2113, -0.5227, 0.3113}
    };


    Mat3 rgbn2yiqMat = new Mat3(A);
    Mat3 yiq2rgbnMat = rgbn2yiqMat.invert();

    public Yiq(ColorFrame _cf) {
        super(_cf);
    }

    public void fromRgb() {
        convertSpace(rgbn2yiqMat);
        System.out.println("yiq");
        rgbn2yiqMat.print();
    }

    /**
     * if ((44 < Y < 223) && (0 < I  < 64))
     * then we have skin
     */
    public void skinChromaKey() {
        for (int x = 0; x < r.length; x++)
            for (int y = 0; y < r[0].length; y++) {
                if (
                        (r[x][y] < 223) &&
                        (r[x][y] > 44) &&
                        (g[x][y] > 0) &&
                        (g[x][y] < 64)
                )
                    setPixel(x, y, 255);
                else
                    setPixel(x, y, 0);
            }

    }

    public void setPixel(int x, int y, int v) {
        r[x][y] = v;
        g[x][y] = v;
        b[x][y] = v;
    }

    public void toRgb() {
        convertSpace(yiq2rgbnMat);
    }

}







