package gui.run.examples;

import gui.ClosableJFrame;
import gui.run.RunColorToggleButton;
import gui.run.RunJob;
import math.MathUtils;

import javax.swing.JPanel;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Color;

public class ColorPanel extends JPanel {
    public static void main(String args[]) {
        class ColorFrame extends ClosableJFrame {
            ColorFrame() {
                super("Colors!");
                Container c = getContentPane();
                c.setLayout(new FlowLayout());
                c.add(new ColorPanel());
                setSize(200, 200);
                show();

            }
        }
        new ColorFrame();


    }

    RunJob job = new RunJob(1, true) {
        public void run() {
            Color randomColor = MathUtils.getRandomColor();
            setBackground(randomColor);
            setForeground(randomColor);
        }
    };

    ColorPanel() {
        super();
        setLayout(new FlowLayout());
        add(new RunColorToggleButton("[ggo") {
            public void run() {
                job.start();
            }
        });
        add(new RunColorToggleButton("[wstop") {
            public void run() {
                job.stop();
            }
        });
    }
}