package gui.run;

import javax.swing.*;
import java.awt.event.*;

/**
 * Just like the RunTextFieldOld except that each
 * char causes an invocation of the run method
 */
public abstract class RunTextField extends
                                   JTextField
        implements ActionListener,
                   FocusListener,
                   Runnable {
    private String originalText = null;

    /**
     * Invoked when a component gains the keyboard focus.
     */
    public void focusGained(FocusEvent e){};

    /**
     * Invoked when a component loses the keyboard focus.
     */
    public void focusLost(FocusEvent e){
        run();
    };

    public String getOriginalText() {
        return originalText;
    }


    public RunTextField(String text) {
        super(text);
        originalText = text;
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
        addFocusListener(this);

    }


    public RunTextField() {
        this("");
    }

    public RunTextField(int columns) {
        super(columns);
        addActionListener(this);
        addFocusListener(this);
    }

    public RunTextField(String text,
                        int columns) {
        super(text, columns);
        addActionListener(this);
        addFocusListener(this);
    }

    public RunTextField(
            javax.swing.text.Document doc,
            String text,
            int columns) {
        super(doc, text, columns);
        addActionListener(this);
        addFocusListener(this);
    }

    public void actionPerformed(
            java.awt.event.ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame(
                "RunTextField");
        java.awt.Container c = cf.getContentPane();
        c.add(new RunTextField(
                "[aWhat is your name?") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.add(new RunTextField(
                "[bWhat is your name?") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.setLayout(
                new java.awt.GridLayout(4, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}