package gui.run;

import javax.swing.*;
import javax.swing.text.Document;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

/**
 * Just like the RunTextFieldOld except that each
 * char causes an invocation of the run method
 */
public abstract class RunTextArea extends
                                   JTextArea
        implements ActionListener,
                   KeyListener,
                   Runnable {
    private String originalText = null;

    public void keyTyped(KeyEvent e) {
    };

    public void keyPressed(KeyEvent e) {
    };

    public void keyReleased(KeyEvent e) {
        run();
    };

    public String getOriginalText() {
        return originalText;
    }


    public RunTextArea(String text) {
        super(text);
        originalText = text;
        addKeyListener(this);

    }

    /**
     * Constructs a new empty TextArea with the
     * specified number of rows and columns.  A
     * default model is created, and the initial
     * string is null.
     *
     * @param rows    the number of rows >= 0
     * @param columns th?e number of columns >= 0
     * @throws IllegalArgumentException if the rows
     *                                  or columns
     *                                  arguments
     *                                  are negative.
     */
    public RunTextArea(int rows, int columns) {
        super(rows, columns);
    }

    /**
     * Constructs a new TextArea with the
     * specified text and number of rows and
     * columns.  A default model is created.
     *
     * @param text    the text to be displayed, or
     *                null
     * @param rows    the number of rows >= 0
     * @param columns the number of columns >= 0
     * @throws IllegalArgumentException if the rows
     *                                  or columns
     *                                  arguments
     *                                  are negative.
     */
    public RunTextArea(String text,
                 int rows,
                 int columns) {
        super(text, rows, columns);
        addKeyListener(this);
    }

    /**
     * Constructs a new JTextArea with the given
     * document model, and defaults for all of the
     * other arguments (null, 0, 0).
     *
     * @param doc the model to use
     */
    public RunTextArea(Document doc) {
        super(doc);
        addKeyListener(this);
    }

    /**
     * Constructs a new JTextArea with the
     * specified number of rows and columns, and
     * the given model.  All of the constructors
     * feed through this constructor.
     *
     * @param doc     the model to use, or create
     *                a default one if null
     * @param text    the text to be displayed,
     *                null if none
     * @param rows    the number of rows >= 0
     * @param columns the number of columns >= 0
     * @throws IllegalArgumentException if the rows
     *                                  or columns
     *                                  arguments
     *                                  are negative.
     */
    public RunTextArea(Document doc,
                 String text,
                 int rows,
                 int columns) {
        super(doc, text, rows, columns);
        addKeyListener(this);
    }


    public RunTextArea() {
        this("");
        addKeyListener(this);
    }

    public void actionPerformed(
            java.awt.event.ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame(
                "RunTextArea");
        java.awt.Container c = cf.getContentPane();
        c.add(new RunTextArea(
                "What is your name?") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.add(new RunTextArea(
                "What is your name?") {
            public void run() {
                System.out.println(getText());
            }
        });
        c.setLayout(
                new java.awt.GridLayout(4, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}