package gui.run;

import gui.ClosableJFrame;

import javax.swing.JPanel;
import javax.swing.JScrollBar;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public abstract class RunScroll
        extends JScrollBar
        implements
        AdjustmentListener,
        Runnable {
    public RunScroll(int orientation,
                     int value,
                     int extent,
                     int min,
                     int max) {
        super(orientation,
                value,
                extent,
                min,
                max);
        addAdjustmentListener(this);
    }

    public RunScroll(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public RunScroll() {
        this(VERTICAL);
    }

    public void adjustmentValueChanged(AdjustmentEvent ae) {
        run();
    }

    private static JPanel getScrollBars(int orientation, int n) {
        JPanel jp = new JPanel();
        if (orientation == RunScroll.VERTICAL)
            jp.setLayout(new GridLayout(1, 0));
        else
            jp.setLayout(new GridLayout(0, 1));
        for (int i = 0; i < n; i++)
            jp.add(new RunScroll(orientation) {
                public void run() {
                    System.out.println("value=" + getValue());
                }
            });
        return jp;
    }

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame();
        cf.setSize(200, 200);
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());
        int n = 9;
        c.add(getScrollBars(RunScroll.HORIZONTAL, n), BorderLayout.NORTH);
        c.add(getScrollBars(RunScroll.HORIZONTAL, n), BorderLayout.SOUTH);
        c.add(getScrollBars(RunScroll.VERTICAL, n), BorderLayout.EAST);
        c.add(getScrollBars(RunScroll.VERTICAL, n), BorderLayout.WEST);
        cf.setVisible(true);
    }
}