package gui.run;


import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class RunMenuItem extends
        JMenuItem
        implements
        ActionListener, Runnable {

    public RunMenuItem(String label) {
        this(label, null);
    }

    public RunMenuItem(String l, Icon i) {
        super(l, i);
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
    }

    public RunMenuItem(Icon i) {
        this(null, i);
    }

    public RunMenuItem() {
        this(null, null);
    }

    public void actionPerformed(ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame("RunMenuItem");
        Container c = cf.getContentPane();
        cf.setJMenuBar(getMenuBar());
        c.setLayout(new java.awt.FlowLayout());
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    public static JMenuBar getMenuBar() {
        JMenuBar mb = new JMenuBar();
        mb.add(getFileMenu());
        mb.add(getEditMenu());
        return mb;
    }

    public static RunMenu getDrawMenu() {
        RunMenu drawMenu = new RunMenu("[draw");
        drawMenu.add(new RunMenuItem("[rect{alt shift R}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[square{shift F12}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[quad{alt 1}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[right arrow{alt RIGHT}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[fat line{ctrl alt shift L}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[circle{ctrl C}") {
            public void run() {
                System.out.println(getText());
            }
        });
        return drawMenu;
    }

    public static RunMenu getEditMenu() {
        RunMenu editMenu = new RunMenu("[Edit");
        editMenu.add(new RunMenuItem("[Undo{control DELETE}") {
            public void run() {
                System.out.println(getText());
            }
        });
        editMenu.add(new RunMenuItem("[cut{ctrl shift C}") {
            public void run() {
                System.out.println(getText());
            }
        });
        editMenu.add(getDrawMenu());
        return editMenu;
    }

    public static RunMenu getFileMenu() {
        RunMenu fileMenu = new RunMenu("[File");
        fileMenu.add(new RunMenuItem("[open{alt shift X}") {
            public void run() {
                System.out.println(getText());
            }
        });
        fileMenu.add(new RunMenuItem("[save{alt control DELETE}") {
            public void run() {
                System.out.println(getText());
            }
        });
        return fileMenu;
    }

}