package gui.html;

import gui.ClosableJFrame;

import javax.swing.*;


public class TextViewer extends ClosableJFrame {

    private JEditorPane textPane
            = new JEditorPane();

    public TextViewer() {
        super("TextViewer");
        java.awt.Container c = getContentPane();
        c.setLayout(new java.awt.GridLayout(1, 0));
        c.add(new JScrollPane(textPane));
        setSize(400, 400);
        setVisible(true);
    }


    public void setRtfText(String s) {
        textPane.setContentType("text/rtf");
        textPane.setText(s);
    }

    public void setPlainText(String s) {
        textPane.setContentType("text/plain");
        textPane.setText(s);
    }

    public void setString(String s) {
        setPlainText(s);
        System.out.println(s);
    }
    public void println(Object o){
        if (o == null ) return;
        String s = textPane.getText();
        s = s +"\n"+ o.toString();
        textPane.setText(s);
    }

    public static void main(String args[]) {
        TextViewer tv = new TextViewer();
        tv.println("Hello World");
        for (int i=0; i < 100; i++)
            tv.println("i="+i);
    }
}