package gui.dialogs;

import javax.swing.*;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 24, 2004
 * <p/>
 * Time: 9:33:06 AM
 */
public class ProgressDialog extends JDialog {
    final JProgressBar jp = new JProgressBar();
    final JLabel jl = new JLabel("% done=" + 0);
    Container c = getContentPane();

    public ProgressDialog() {
        c.setLayout(new GridLayout(0,1));
        c.add(jp);
        c.add(jl);
        jp.setMinimum(0);
        jp.setMaximum(100);
    }
    public void incrementValue(int i) {
        setValue(jp.getValue() + i);
    }
    public void setValue(int i){
        jp.setValue(i);
        jl.setText("% done=" + i);
    }

    public Dimension getPreferredSize() {
        return new Dimension(100,100);
    }

    public Dimension getMinimumSize() {
        return getPreferredSize();
    }
    public static void main(String[] args) {
        ProgressDialog pd = new ProgressDialog();
        pd.setSize(200,200);
        pd.show();
        for (int i = 0; i <= 100; i++) {
            pd.setValue(i);
            sleep();
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(250);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
