package gui.dialogs;

import javax.swing.*;
import java.awt.*;


/**
 * This class implements a LabelledItemPanel for entering Customer data.
 */
public class CustomerPanel extends LabelledItemPanel {
    // Constants

    private static final String[] COUNTRY_LIST =
            {
                "Australia", "England", "Japan", "USA"
            };

    // Attributes

    private JTextField myCustomerCodeField = new JTextField();
    private JTextField myNameField = new JTextField();
    private JTextArea myAddressField = new JTextArea(3, 20);
    private JTextField myCityField = new JTextField();
    private JTextField myStateField = new JTextField();
    private JTextField myPostcodeField = new JTextField();
    private JComboBox myCountryField = new JComboBox(COUNTRY_LIST);
    private JTextField myContactField = new JTextField();
    private JTextField myPhoneField = new JTextField();
    private JTextField myFaxField = new JTextField();
    private JTextField myEmailField = new JTextField();

    // Methods

    /**
     * This method is the default constructor.
     */
    public CustomerPanel() {
        init();
    }

    /**
     * This method initialises the components on the panel.
     */
    private void init() {
        setBorder(BorderFactory.createEtchedBorder());

        addItem("Customer Code", myCustomerCodeField);
        addItem("Name", myNameField);
        addItem("Address", new JScrollPane(myAddressField,
                JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                JScrollPane.HORIZONTAL_SCROLLBAR_NEVER));
        addItem("City", myCityField);
        addItem("State", myStateField);
        addItem("Postcode", myPostcodeField);
        addItem("Country", myCountryField);
        addItem("Contact", myContactField);
        addItem("Phone", myPhoneField);
        addItem("Fax", myFaxField);
        addItem("Email", myEmailField);
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public CustomerData getCustomerData() {
        CustomerData customerData = new CustomerData();

        customerData.setCustomerCode(myCustomerCodeField.getText());
        customerData.setName(myNameField.getText());
        customerData.setAddress(myAddressField.getText());
        customerData.setCity(myCityField.getText());
        customerData.setState(myStateField.getText());
        customerData.setZip(myPostcodeField.getText());
        customerData.setCountry(myCountryField.getSelectedItem().toString());
        customerData.setContact(myContactField.getText());
        customerData.setPhone1(myPhoneField.getText());
        customerData.setFax(myFaxField.getText());
        customerData.setEmail(myEmailField.getText());

        return customerData;
    }

    /**
     * This method sets the values of the panel entry fields.
     *
     * @param customerData The object containing the Customer data
     */
    public void setCustomerData(CustomerData customerData) {
        myCustomerCodeField.setText(customerData.getCustomerCode());
        myNameField.setText(customerData.getName());
        myAddressField.setText(customerData.getAddress());
        myCityField.setText(customerData.getCity());
        myStateField.setText(customerData.getState());
        myPostcodeField.setText(customerData.getZip());
        myCountryField.setSelectedItem(customerData.getCountry());
        myContactField.setText(customerData.getContact());
        myPhoneField.setText(customerData.getPhone1());
        myFaxField.setText(customerData.getFax());
        myEmailField.setText(customerData.getEmail());
    }

    /**
     * This method demonstrates the usage of the CustomerPanel class.
     */
    public static void main(String[] args) {
        // Create an instance of the panel

        CustomerPanel panel = new CustomerPanel();

        // Create a dialog to hold the panel

        ModalJDialog dialog = new ModalJDialog((Frame) null, "Customer Details (LabelledItemPanel)");

        dialog.setContentPane(panel);

        dialog.pack();

        // Present it to a User

        dialog.show();

        // Get the data and display it

        if (!dialog.hasUserCancelled()) {
            CustomerData customerData = panel.getCustomerData();

            customerData.printData();
        }

        System.exit(0);
    }
}