package gui.dialogs;

import classUtils.reflection.MethodList;
import gui.In;
import xml.adbk.Address;

import javax.swing.*;
import java.lang.reflect.Method;

import gui.In;

/**
 * This class demonstrates the usage of the StandardDialog class.
 */
public class AddressDialog extends ModalJDialog {

    Method writeMethods[] = null;
    MethodList ml = null;

    private JTextField tf[] = null;

    private LabelledItemPanel myContentPane = new LabelledItemPanel();

    public AddressDialog(Class c) {
        ml = new MethodList(c);
        writeMethods = ml.getWriteMethods();
        init();
    }

    private void init() {
        setTitle("Customer Dialog (StandardDialog)");
        tf = new JTextField[writeMethods.length];
        String propNames[] = ml.getPropertyNames();
        for (int i = 0; i < propNames.length; i++) {

            tf[i] = new JTextField(20);
            myContentPane.addItem(propNames[i], tf[i]);
            if (i > 5) break;

        }
        myContentPane.setBorder(BorderFactory.createEtchedBorder());

        setContentPane(myContentPane);
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public CustomerData getData() {
        CustomerData customerData = new CustomerData();
        customerData.setCustomerCode(tf[1].getText());
        return customerData;
    }

    /**
     * This method sets the values of the panel entry fields.
     *
     * @param customerData The object containing the Customer data
     */
    public void setCustomerData(CustomerData customerData) {
        tf[1].setText(customerData.getCustomerCode());

    }

    /**
     * This method checks that the data entered is valid.
     * To be valid, the following must be met:
     * <LI>Customer Code field is not blank
     * <LI>Name field is not blank
     *
     * @return <code>true</code> if the data is valid, otherwise
     *         <code>false</code>
     */
    protected boolean isValidData() {
        if (tf[1].getText().equals("")) {
            In.message("Please enter an address");

            tf[1].requestFocus();

            return false;
        }


        return true;
    }

    public static void main(String[] args) {
        AddressDialog dialog = new AddressDialog(StudentData.class);
        dialog.pack();
        dialog.show();
        CustomerData customerData = dialog.getData();

        customerData.printData();

        System.exit(0);
    }
}