package gui.browser;

import javax.swing.*;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class BrowserListener
        implements HyperlinkListener {

    BrowserLogic bl;
    JTextField tf;

    public BrowserListener(BrowserLogic _bl, JTextField _tf) {
        bl = _bl;
        tf = _tf;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() ==
                HyperlinkEvent.EventType.ACTIVATED) {
            processActivated(e);
        }
    }

    private void processActivated(HyperlinkEvent e) {
        JEditorPane jep =
                (JEditorPane) e.getSource();
        if (e instanceof HTMLFrameHyperlinkEvent)
            processHyperLinkEvent(e, jep);
        else {
            //     new ThreadedLoad(jep,e.getURL());
            bl.hyperlinkPage(jep, e, tf);
        }
    }

    private void setPage(JEditorPane jep,
                         HyperlinkEvent e) {
        new ThreadedLoad(jep, e.getURL());
    }


    private void processHyperLinkEvent(
            HyperlinkEvent e, JEditorPane pane) {
        HTMLFrameHyperlinkEvent hle = (HTMLFrameHyperlinkEvent) e;
        HTMLDocument htmlDoc = (HTMLDocument) pane.getDocument();
        htmlDoc.processHTMLFrameHyperlinkEvent(hle);
    }
}