/*
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Feb 15, 2003
 * Time: 8:49:30 AM
 */
package gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

public class PetriBean {
    private int place = 1;
    private String ps = null;
    private ActionListener al;

    public PetriBean(ActionListener _al) {
        al = _al;
    }

    public boolean matchSilent(AWTEvent e, MenuItem mi) {
        if (e.getSource() == mi) return true;

        if (e.getSource() instanceof MenuItem) return false;
        if (getPs() == null) return false;
        if (mi.getLabel().startsWith(getPs())) return true;
        return false;
    }

    public boolean matchSilent(AWTEvent e, JMenuItem mi) {
        if (e.getSource() == mi) return true;

        if (e.getSource() instanceof JMenuItem) return false;
        if (getPs() == null) return false;
        if (mi.getText().startsWith(getPs())) return true;
        return false;
    }

    public String getPs() {
        return ps;
    }

    public void setPs(String ps) {
        this.ps = ps;
    }

    private String petriMap(int c) {
        String s = "[" + (char) c + "]";
        switch (place) {
            case 1:
                if (isEsc(c)) {
                    // t1
                    place = 2;
                    return null;
                }
                if (isTab(c)) {
                    // t2
                    place = 4;
                    return null;
                }
                return s;
            case 2:
                if (isTab(c)) {
                    // t3
                    place = 3;
                    return null;
                }
                if (isEsc(c))
                    return null;
                // t4
                place = 1;
                ps = "[E-" + (char) c + "]";
                return (ps);
            case 3:
                if (isTab(c))
                    return null;
                if (isEsc(c)) {
                    // t5
                    place = 1;
                    return null;
                }
                // t6
                place = 1;
                ps = "[E-T-" + (char) c + "]";
                return (ps);
            case 4:
                if (isEsc(c)) {
                    // t7
                    place = 1;
                    return null;
                }
                if (isTab(c)) return null;
                // t8
                place = 1;
                ps = "[T-" + (char) c + "]";
                return (ps);
        }
        ps = s;
        return ps;
    }

    private boolean isEsc(int c) {
        return (c == 27);
    }

    private boolean isTab(int c) {
        return (c == '\t');
    }

    public void processEvent(KeyEvent e) {
        int charValue = e.getKeyChar();
        setPs(petriMap(charValue));
        al.actionPerformed(new ActionEvent(e,
                ActionEvent.ACTION_PERFORMED, charValue + ""));
    }

    public String mapModifiers(KeyEvent e) {
        String modString =
                KeyEvent.getKeyModifiersText(
                        e.getModifiers());
        String newMods = "";
        if (modString.indexOf("Ctrl") != -1) newMods += "^-";
        if (modString.indexOf("Command") != -1) newMods += "A-";
        if (modString.indexOf("Option") != -1) newMods += "C-";
        return newMods;
        //Command+Ctrl+Option
    }

    public String getShortCut(KeyEvent e) {
        int modifiers = e.getModifiers();
        StringBuffer buf = new StringBuffer();
        if ((modifiers & InputEvent.CTRL_MASK) != 0) {
            buf.append("^");
            buf.append("+");
        }
        if ((modifiers & InputEvent.META_MASK) != 0) {
            buf.append("Meta");
            buf.append("+");
        }
        if ((modifiers & InputEvent.ALT_MASK) != 0) {
            buf.append("@");
            buf.append("+");
        }
        return buf.toString();
    }

    public boolean matchEvent(AWTEvent e, MenuItem mi) {
        boolean b = matchSilent(e, mi);
        if (b) {
            System.out.println(mi.getLabel());
        }
        return b;
    }

    public boolean matchEvent(AWTEvent e, JMenuItem mi) {
        boolean b = matchSilent(e, mi);
        if (b) {
            System.out.println(mi.getText());
        }
        return b;
    }
}
