package gui;

import j2d.ShortImageBean;

import java.awt.*;
import java.awt.image.ColorModel;
import java.io.File;

public class ImageBean implements ImageBeanInterface {

    private Image image;
    private ColorModel cm = ColorModel.getRGBdefault();
    private int w = 0;
    private int h = 0;

// A default file name..set to null
// to start with file open dialog.
// Set to string to start with an image.
// Use a fully qualified path name, in quotes.
    private File f = null;

    private boolean fromFile = false;

    public Image getImage() {
        return image;
    }

    public void setImage(ShortImageBean sib) {
        image = sib.getImage();
        w = sib.getWidth();
        h = sib.getHeight();
    }


    public void setImage(Image _image) {
        this.image = _image;
        w = image.getWidth(null);
        h = image.getHeight(null);
    }

    public ColorModel getColorModel() {
        return cm;
    }

    public boolean isFromFile() {
        return fromFile;
    }

    public void setFromFile(boolean fromFile) {
        this.fromFile = fromFile;
    }

    public int getImageWidth() {
        return w;
    }


    public int getImageHeight() {
        return h;
    }

    public void setImageHeight(int _h) {
        h = _h;
    }

    public void setImageWidth(int _w) {
        w = _w;
    }


    public File getFile() {
        return f;
    }

    public void setFile(File _f) {
        f = _f;
        setFromFile(true);
    }
}

