package gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ClosableJFrame extends JFrame {
    public ClosableJFrame() {
        this("");
    }

    public ClosableJFrame(String title) {
        super(title);
        setBackground(Color.white);
        addWindowListener(
                new ClosingWindowAdapter());
    }

    public void addMouseController(gui.mouse.MouseController mc) {
        addMouseMotionListener(mc);
        addMouseListener(mc);
    }

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame("ClosableJFrame");
        cf.setSize(200, 200);
        cf.setVisible(true);

    }


    private class ClosingWindowAdapter extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            setVisible(false);
            dispose();
        }
    }
}