package graphics.screenSaver;

import futils.Futil;
import utils.Base64;
import utils.SystemUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Sep 21, 2004
 * Time: 1:12:46 PM
 */

/**
 * This class contains a win32 screen
 * saver
 */
public class Win32 {
    private static String bouncingballDotjarName = "bouncingball.jar";
    private static String bouncingballDotjar =
            "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";
    private static String bouncingballDotscrName = "bouncingball.scr";
    private static String bouncingballDotscr =
            "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";
    private static String COPYINGName = "COPYING";
    private static String COPYING =
            "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";
    private static String saverbeansDashapiDotjarName = "saverbeans-api.jar";
    private static String saverbeansDashapiDotjar =
            "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";

    public static void main(String[] args) {
        try {
            testDecoder();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    private static void testDecoder() throws IOException {
        File systemDir = //"C:\\WINDOWS\\system32\\";
                Futil.getReadDirFile("select an output directory");
        writeOutFileNameAndData(systemDir, bouncingballDotjarName, bouncingballDotjar);
        writeOutFileNameAndData(systemDir, bouncingballDotscrName, bouncingballDotscr);
        writeOutFileNameAndData(systemDir, COPYINGName, COPYING);
        writeOutFileNameAndData(systemDir, saverbeansDashapiDotjarName, saverbeansDashapiDotjar);

    }

    private static void writeOutFileNameAndData(File systemDir, String fileName, String stringData) throws IOException {
        File f = new File(systemDir + SystemUtils.getDirectorySeparator() + fileName);

        writeBytes(stringData, f);
    }

    private static void writeBytes(String stringData, File f) throws IOException {
        byte b[] = (byte[]) Base64.decodeToObject(stringData);

        FileOutputStream fos = new FileOutputStream(f);
        fos.write(b);
        fos.close();
    }
}
