package graphics.raytracers.rmiRaytracer.raytracer;

//
// note: None of the methods return a vector. They will modify the current
// vector object.
//

class Vec {
    double x, y, z;

    public Vec() {
        x = 0;
        y = 0;
        z = 0;
    }

    public Vec(double ix, double iy, double iz) {
        x = ix;
        y = iy;
        z = iz;
    }

    public Vec(Vec v) {
        x = v.x;
        y = v.y;
        z = v.z;
    }

    public void set(double nx, double ny, double nz) {
        x = nx;
        ny = ny;
        z = nz;
    }

    public void normalize() {
        double length;

        length = Math.sqrt(x * x + y * y + z * z);

        try {
            x = x / length;
            y = y / length;
            z = z / length;
        } catch (ArithmeticException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public double dotProduct(Vec v) {
        return ((x * v.x + y * v.y + z * v.z));
    }

    // this = this crosses v
    public void crossProduct(Vec v) {
        double tmpx = y * v.z - z * v.y,
                tmpy = z * v.x - x * v.z,
                tmpz = x * v.y - y * v.x;
        x = tmpx;
        y = tmpy;
        z = tmpz;
    }

    public void mult(double factor) {
        x = x * factor;
        y = y * factor;
        z = z * factor;
    }

    public void add(Vec v) {
        x = x + v.x;
        y = y + v.y;
        z = z + v.z;
    }

    // subtracts v from this vector
    public void sub(Vec v) {
        x = x - v.x;
        y = y - v.y;
        z = z - v.z;
    }

    public String toString() {
        String res = new String("[" + x + ", " + y + ", " + z + "]");
        return res;
    }
}